/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLRecord
implements Cloneable {
    private Object[] m_record;

    public SQLRecord() {
        this(0);
    }

    public SQLRecord(int initialSize) {
        this.m_record = new Object[initialSize];
    }

    public int getColumnCount() {
        return this.m_record.length / 3;
    }

    public void setColumn(int idx, String name) {
        if (idx >= this.m_record.length / 3) {
            this.resize(idx + 1);
        }
        this.m_record[idx * 3] = name;
    }

    public String getColumn(int idx) {
        return (String)this.m_record[idx * 3];
    }

    public void setColumnType(int idx, Class c) {
        if (idx >= this.m_record.length / 3) {
            this.resize(idx + 1);
        }
        this.m_record[idx * 3 + 1] = c;
    }

    public Class getColumnType(String name) {
        int idx = this.getIndex(name);
        return (Class)this.m_record[idx * 3 + 1];
    }

    public Class getColumnType(int idx) {
        return (Class)this.m_record[idx * 3 + 1];
    }

    public void setValue(int idx, Object value) {
        if (idx >= this.m_record.length / 3) {
            this.resize(idx + 1);
        }
        this.m_record[idx * 3 + 2] = value;
    }

    public void setValue(String name, Object value) {
        this.setValue(this.getIndex(name), value);
    }

    public void setColumn(int idx, String name, Class c, Object value) {
        this.setColumn(idx, name);
        this.setColumnType(idx, c);
        this.setValue(idx, value);
    }

    public void setColumn(int idx, String name, Class c) {
        this.setColumn(idx, name);
        this.setColumnType(idx, c);
    }

    public Object getValue(int idx) {
        return this.m_record[idx * 3 + 2];
    }

    public boolean getBoolValue(String name) {
        int idx = this.getIndex(name);
        if (idx == -1) {
            return false;
        }
        return this.getBoolValue(idx);
    }

    public boolean getBoolValue(int idx) {
        Object value = this.getValue(idx);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new NumberFormatException("Value is not a boolean");
    }

    public double getDoubleValue(int idx) {
        Object value = this.getValue(idx);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public double getDoubleValue(String name) {
        int idx = this.getIndex(name);
        if (idx == -1) {
            return 0.0;
        }
        return this.getDoubleValue(idx);
    }

    public int getIntValue(int idx) {
        Object value = this.getValue(idx);
        if (value == null) {
            return 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        throw new NumberFormatException("Value is not a number");
    }

    public long getLongValue(int idx) {
        Object value = this.getValue(idx);
        if (value == null) {
            return 0L;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public long getLongValue(String name) {
        int idx = this.getIndex(name);
        if (idx == -1) {
            return 0L;
        }
        return this.getLongValue(idx);
    }

    public String getString(String name) {
        return (String)this.getValue(name);
    }

    public String getString(int idx) {
        return (String)this.getValue(idx);
    }

    public Object getValue(String name) {
        int idx = this.getIndex(name);
        if (idx == -1) {
            return null;
        }
        return this.m_record[idx * 3 + 2];
    }

    public int getIntValue(String name) {
        int idx = this.getIndex(name);
        if (idx == -1) {
            return 0;
        }
        return this.getIntValue(idx);
    }

    public int getIndex(String name) {
        if (name == null) {
            return -1;
        }
        for (int i = 0; i < this.m_record.length; i += 3) {
            if (!name.equalsIgnoreCase((String)this.m_record[i])) continue;
            return i / 3;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public int hashCode() {
        int hashCode = 13;
        for (int i = 0; i < this.m_record.length; ++i) {
            if (this.m_record[i] == null) continue;
            hashCode += i * 43 + this.m_record[i].hashCode();
        }
        return hashCode;
    }

    private final void resize(int idx) {
        if (idx <= this.m_record.length / 3) {
            return;
        }
        Object[] record = new Object[idx * 3];
        System.arraycopy(this.m_record, 0, record, 0, this.m_record.length);
        this.m_record = record;
    }

    public SQLRecord cloneDefinition() {
        SQLRecord record = new SQLRecord(this.getColumnCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            record.setColumn(i, this.getColumn(i), this.getColumnType(i));
        }
        return record;
    }

    public Object clone() {
        SQLRecord record = new SQLRecord(this.getColumnCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            record.setColumn(i, this.getColumn(i), this.getColumnType(i), this.getValue(i));
        }
        return record;
    }

    public static final SQLRecord createRecord(ResultSet rs) throws SQLException {
        try {
            ResultSetMetaData meta = rs.getMetaData();
            SQLRecord record = new SQLRecord(meta.getColumnCount());
            for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
                record.setColumn(i - 1, meta.getColumnName(i), Class.forName(meta.getColumnClassName(i)), rs.getObject(i));
            }
            return record;
        }
        catch (ClassNotFoundException cnfex) {
            throw new SQLException("Cannot determine datatype for one of the fields");
        }
    }

    public static final SQLRecord createEmptyRecord(ResultSetMetaData meta) throws SQLException {
        try {
            SQLRecord record = new SQLRecord(meta.getColumnCount());
            for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
                record.setColumn(i - 1, meta.getColumnName(i), Class.forName(meta.getColumnClassName(i)));
            }
            return record;
        }
        catch (ClassNotFoundException cnfex) {
            throw new SQLException("Cannot determine datatype for one of the fields");
        }
    }
}

