/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.brains2b.sql.Connector;

public class RemoteConnector
implements Connector {
    private Connection m_con;
    private String m_lookupName;

    public RemoteConnector(String lookupName) {
        this.m_lookupName = lookupName;
    }

    public void close() throws SQLException {
        this.m_con.close();
        this.m_con = null;
    }

    public Connection getConnection() throws SQLException {
        if (this.m_con == null) {
            this.m_con = this.createConnection();
        }
        return this.m_con;
    }

    public String getUser() {
        if (this.m_con == null) {
            return null;
        }
        try {
            return this.m_con.getMetaData().getUserName();
        }
        catch (SQLException sqex) {
            return null;
        }
    }

    private Connection createConnection() throws SQLException {
        try {
            InitialContext context = new InitialContext();
            DataSource ds = (DataSource)context.lookup(this.m_lookupName);
            return ds.getConnection();
        }
        catch (NamingException nex) {
            throw new SQLException("Could not connect to database");
        }
    }

    public Object clone() {
        return new RemoteConnector(this.m_lookupName);
    }
}

