/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.brains2b.loader.DynamicClassLoader;
import org.brains2b.sql.Connector;

public class LocalConnector
implements Connector {
    private Connection m_con;
    protected String m_url;
    protected Driver m_driver;
    protected Properties m_info;

    protected LocalConnector() {
    }

    public LocalConnector(String driver, String url, String user, String password) {
        this.init(null, driver, url, user, password);
    }

    public LocalConnector(String classpath, String driver, String url, String user, String password) {
        this.init(classpath, driver, url, user, password);
    }

    public Connection getConnection() throws SQLException {
        if (this.m_driver == null) {
            throw new SQLException("Cannot find driver");
        }
        if (this.m_con == null) {
            this.m_con = this.m_driver.connect(this.m_url, this.m_info);
        }
        return this.m_con;
    }

    public void close() throws SQLException {
        if (this.m_con != null) {
            this.m_con.close();
        }
        this.m_con = null;
    }

    protected void init(String classPath, String driver, String url, String user, String password) {
        this.m_url = url;
        this.m_info = new Properties();
        this.m_info.setProperty("user", user);
        this.m_info.setProperty("password", password);
        URL[] path = null;
        if (classPath != null) {
            path = this.makeClassPath(classPath);
        }
        try {
            Class clazz = DynamicClassLoader.loadClass((String)driver, (URL[])path);
            this.m_driver = (Driver)clazz.newInstance();
        }
        catch (ClassNotFoundException ce) {
            System.err.println(ce.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getUser() {
        String s = this.m_info.getProperty("user");
        if (this.m_url.indexOf("oracle") != -1) {
            return s.toUpperCase();
        }
        return s;
    }

    public String getDbName() {
        if (this.m_url != null) {
            int start = this.m_url.lastIndexOf(47) + 1;
            if (start == 0) {
                start = this.m_url.lastIndexOf(":") + 1;
            }
            return this.m_url.substring(start);
        }
        return null;
    }

    public String getServerName() {
        if (this.m_url != null) {
            int end;
            int start = this.m_url.lastIndexOf("@") + 1;
            if (start == 0) {
                start = this.m_url.indexOf("//") + 2;
            }
            if ((end = this.m_url.indexOf(":", start)) == -1) {
                end = this.m_url.indexOf("/", start);
            } else if (this.m_url.indexOf(46, start) != -1) {
                end = this.m_url.indexOf(46, start);
            }
            return this.m_url.substring(start, end);
        }
        return null;
    }

    private URL[] makeClassPath(String classpath) {
        try {
            StringTokenizer st = new StringTokenizer(classpath, ";");
            URL[] urls = new URL[st.countTokens()];
            int cnt = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith(System.getProperty("file.separator"))) {
                    urls[cnt++] = new File(s).toURL();
                    continue;
                }
                urls[cnt++] = new File(System.getProperty("user.dir"), s).toURL();
            }
            return urls;
        }
        catch (MalformedURLException mfuex) {
            return null;
        }
    }

    public Object clone() {
        return new LocalConnector(this.m_driver.getClass().getName(), this.m_url, this.getUser(), this.m_info.getProperty("password"));
    }
}

