/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.squeler.ddl;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLMetaModel;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.squeler.ddl.ColumnDDL;
import org.brains2b.squeler.ddl.ColumnRelation;
import org.brains2b.squeler.ddl.DDLDefinition;
import org.brains2b.squeler.ddl.DDLWriter;
import org.brains2b.squeler.ddl.SquelerDDLException;

public class TableDDL
extends TableModel
implements DDLWriter,
DDLDefinition,
ColumnRelation {
    private boolean temporary;
    private boolean m_qualified;
    private String m_tablespace;
    private int m_action;

    public TableDDL() {
        SQLRecord record = new SQLRecord(5);
        record.setColumn(0, "TABLE_TYPE", String.class, (Object)"TABLE");
        record.setColumn(1, "TABLE_NAME", String.class);
        record.setColumn(2, "TABLE_CAT", String.class);
        record.setColumn(3, "TABLE_SCHEM", String.class);
        record.setColumn(4, "REMARKS", String.class);
        this.setRecord(record);
    }

    public TableDDL(TableModel model) {
        this.setModel((SQLMetaModel)model);
    }

    public TableDDL(String catalog, String schema, String name, String remarks) {
        SQLRecord record = new SQLRecord(5);
        record.setColumn(0, "TABLE_TYPE", String.class, (Object)"TABLE");
        record.setColumn(1, "TABLE_NAME", String.class, (Object)name);
        record.setColumn(2, "TABLE_CAT", String.class, (Object)catalog);
        record.setColumn(3, "TABLE_SCHEM", String.class, (Object)schema);
        record.setColumn(4, "REMARKS", String.class, (Object)remarks);
        this.setRecord(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Connection con) throws SquelerDDLException, SQLException {
        Statement stmt = con.createStatement();
        try {
            stmt.execute(this.getStatement().toString());
        }
        finally {
            stmt.close();
        }
    }

    public void write(PrintWriter writer) throws SquelerDDLException, IOException {
        writer.println(this.getStatement().append(";\n").toString());
    }

    protected StringBuffer createStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE ");
        if (this.temporary) {
            sb.append("TEMPORARY ");
        }
        sb.append("TABLE ");
        sb.append(this.getName());
        sb.append("(");
        if (this.getColumns() == null || this.getColumns().isEmpty()) {
            throw new SquelerDDLException(this.getType(), this.getName(), "{type} {name} has no columns");
        }
        sb.append("\n");
        List v = this.getColumns();
        for (int i = 0; i < v.size(); ++i) {
            ColumnDDL column = (ColumnDDL)v.get(i);
            sb.append("\t");
            sb.append(column.getStatement(this.getType(), this.getAction()).toString());
            if (i < v.size() - 1) {
                sb.append(",\n");
                continue;
            }
            sb.append(")\n");
        }
        if (this.getTablespace() != null) {
            sb.append("TABLESPACE ").append(this.getTablespace());
        }
        return sb;
    }

    public void addColumn(ColumnDDL column) {
        column.setTableName(this.getName());
        if (this.getColumns() == null) {
            ArrayList l = new ArrayList();
            this.setColumns(l);
        }
        this.getColumns().add(column);
    }

    public void setTableCat(String tableCat) {
        this.getRecord().setValue("CATALOG", (Object)tableCat);
    }

    public void setTableSchema(String tableSchema) {
        this.getRecord().setValue("SCHEMA", (Object)tableSchema);
    }

    public void setTableName(String tableName) {
        this.getRecord().setValue("TABLE_NAME", (Object)tableName);
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean b) {
        this.temporary = b;
    }

    public String toString() {
        try {
            return this.getStatement().toString();
        }
        catch (SquelerDDLException sqex) {
            return sqex.getMessage();
        }
    }

    public void setModel(SQLMetaModel model) {
        if (!(model instanceof TableModel)) {
            throw new IllegalArgumentException("Cannot create TableDDL on non TableModel");
        }
        this.setRecord(model.getRecord());
        if (((TableModel)model).getColumns() != null) {
            Iterator it = ((TableModel)model).getColumns().iterator();
            while (it.hasNext()) {
                ColumnModel cm = (ColumnModel)it.next();
                this.addColumn(new ColumnDDL(cm));
            }
        }
    }

    public StringBuffer getStatement() throws SquelerDDLException {
        switch (this.getAction()) {
            case 4: {
                return this.dropStatement();
            }
            case 3: {
                throw new SquelerDDLException(this.getType(), this.getName(), "{type} update not implemented at the moment");
            }
        }
        return this.createStatement();
    }

    protected StringBuffer dropStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP ").append(this.getType()).append(" ").append(this.getName());
        return sb;
    }

    public int getAction() {
        return this.m_action;
    }

    public boolean isQualified() {
        return this.m_qualified;
    }

    public boolean isReplaceable() {
        return false;
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public void setQualified(boolean b) {
        this.m_qualified = b;
    }

    public String getTablespace() {
        return this.m_tablespace;
    }

    public void setTablespace(String tablespace) {
        this.m_tablespace = tablespace;
    }

    public void setColumns(List columns) {
        super.setColumns(columns);
    }
}

