/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.squeler.ddl;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.IndexModel;
import org.brains2b.sql.meta.SQLMetaModel;
import org.brains2b.squeler.ddl.ColumnDDL;
import org.brains2b.squeler.ddl.ColumnRelation;
import org.brains2b.squeler.ddl.DDLDefinition;
import org.brains2b.squeler.ddl.DDLWriter;
import org.brains2b.squeler.ddl.SquelerDDLException;

public class IndexDDL
extends IndexModel
implements DDLWriter,
DDLDefinition,
ColumnRelation {
    private int m_action;
    private String m_tablespace;
    private boolean m_dropWithTable;

    public IndexDDL() {
        SQLRecord record = new SQLRecord(7);
        record.setColumn(0, "INDEX_TYPE", String.class, (Object)"INDEX");
        record.setColumn(1, "INDEX_NAME", String.class);
        record.setColumn(2, "TABLE_CAT", String.class);
        record.setColumn(3, "TABLE_SCHEM", String.class);
        record.setColumn(4, "TABLE_NAME", String.class);
        record.setColumn(5, "NON_UNIQUE", Integer.class);
        record.setColumn(6, "TYPE", Integer.class);
        this.setRecord(record);
    }

    public IndexDDL(String indexName, String tableName, boolean unique) {
        SQLRecord record = new SQLRecord(7);
        record.setColumn(0, "INDEX_TYPE", String.class, (Object)"INDEX");
        record.setColumn(1, "INDEX_NAME", String.class, (Object)indexName);
        record.setColumn(2, "TABLE_CAT", String.class);
        record.setColumn(3, "TABLE_SCHEM", String.class);
        record.setColumn(4, "TABLE_NAME", String.class, (Object)tableName);
        record.setColumn(5, "NON_UNIQUE", Integer.class, (Object)new Integer(unique ? 0 : 1));
        record.setColumn(6, "TYPE", Integer.class);
        this.setRecord(record);
    }

    public StringBuffer getStatement() throws SquelerDDLException {
        switch (this.getAction()) {
            case 3: {
                return this.alterStatement();
            }
            case 4: {
                return this.dropStatement();
            }
        }
        return this.createStatement();
    }

    public void addColumn(ColumnDDL column) {
        column.setTableName(this.getName());
        if (this.getColumns() == null) {
            ArrayList l = new ArrayList();
            this.setColumns(l);
        }
        this.getColumns().add(column);
    }

    public void write(PrintWriter writer) throws SquelerDDLException, IOException {
        writer.println(this.getStatement().append(";"));
    }

    public void write(Connection con) throws SquelerDDLException, SQLException {
        Statement stmt = con.createStatement();
        stmt.execute(this.getStatement().toString());
    }

    public String toString() {
        try {
            return this.getStatement().toString();
        }
        catch (SquelerDDLException sqex) {
            return sqex.getMessage();
        }
    }

    public int getAction() {
        return this.m_action;
    }

    public boolean isQualified() {
        return false;
    }

    public boolean isReplaceable() {
        return false;
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public void setModel(SQLMetaModel model) {
        if (!(model instanceof IndexModel)) {
            throw new IllegalArgumentException("Cannot create TableDDL on non TableModel");
        }
        this.setRecord(model.getRecord());
        if (((IndexModel)model).getColumns() != null) {
            Iterator it = ((IndexModel)model).getColumns().iterator();
            while (it.hasNext()) {
                ColumnModel cm = (ColumnModel)it.next();
                this.addColumn(new ColumnDDL(cm));
            }
        }
    }

    private StringBuffer createStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE ");
        if (this.isUnique()) {
            sb.append("UNIQUE ");
        }
        sb.append("INDEX ");
        sb.append(this.getName());
        sb.append(" ON ");
        sb.append(this.getTableName());
        if (this.getColumns() == null || this.getColumns().isEmpty()) {
            throw new SquelerDDLException(this.getType(), this.getName(), "No columns defined for {type} {name}");
        }
        sb.append("(");
        for (int i = 0; i < this.getColumns().size(); ++i) {
            ColumnModel column = (ColumnModel)this.getColumns().get(i);
            sb.append(column.getName());
            if (i < this.getColumns().size() - 1) {
                sb.append(", ");
                continue;
            }
            sb.append(") ");
        }
        if (this.getTablespace() != null) {
            sb.append("TABLESPACE ").append(this.getTablespace());
        }
        return sb;
    }

    private StringBuffer dropStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        sb.append("DROP ").append(this.getType()).append(" ").append(this.getName());
        if (this.isDropWithTable()) {
            sb.append(" ON ").append(this.getTableName());
        }
        return sb;
    }

    private StringBuffer alterStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        return sb;
    }

    public void setColumns(List columns) {
        super.setColumns(columns);
    }

    public String getTablespace() {
        return this.m_tablespace;
    }

    public void setTablespace(String tablespace) {
        this.m_tablespace = tablespace;
    }

    public boolean isDropWithTable() {
        return this.m_dropWithTable;
    }

    public void setDropWithTable(boolean dropWithTable) {
        this.m_dropWithTable = dropWithTable;
    }

    public void setUnique(boolean unique) {
        this.getRecord().setValue("NON_UNIQUE", (Object)unique);
    }
}

