/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.squeler.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.ConstraintModel;
import org.brains2b.sql.meta.SQLMetaModel;
import org.brains2b.squeler.ddl.ColumnDDL;
import org.brains2b.squeler.ddl.ColumnRelation;
import org.brains2b.squeler.ddl.DDLDefinition;
import org.brains2b.squeler.ddl.SquelerDDLException;
import org.brains2b.util.StringHelper;

public class ConstraintDDL
extends ConstraintModel
implements DDLDefinition,
ColumnRelation {
    private int m_action;

    public ConstraintDDL() {
        SQLRecord record = new SQLRecord(8);
        record.setColumn(0, "TYPE", String.class, (Object)"PRIMARY KEY");
        record.setColumn(1, "NAME", String.class);
        record.setColumn(2, "TABLE_CAT", String.class);
        record.setColumn(3, "TABLE_SCHEM", String.class);
        record.setColumn(4, "TABLE_NAME", String.class);
        record.setColumn(5, "UPDATE_RULE", Integer.class);
        record.setColumn(6, "DELETE_RULE", Integer.class);
        record.setColumn(7, "RULE", String.class);
        this.setRecord(record);
    }

    public int getAction() {
        return this.m_action;
    }

    public StringBuffer getStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(this.getRecord().getString("TABLE_NAME")).append(" ");
        switch (this.getAction()) {
            case 3: {
                return this.alterStatement(sb);
            }
            case 4: {
                return this.dropStatement(sb);
            }
        }
        return this.createStatement(sb);
    }

    public boolean isQualified() {
        return false;
    }

    public boolean isReplaceable() {
        return false;
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public void setModel(SQLMetaModel model) {
        this.setRecord(model.getRecord());
        if (((ConstraintModel)model).getColumns() != null) {
            Iterator it = ((ConstraintModel)model).getColumns().iterator();
            while (it.hasNext()) {
                ColumnModel cm = (ColumnModel)it.next();
                this.addColumn(new ColumnDDL(cm));
            }
        }
    }

    public void addColumn(ColumnDDL column) {
        if (this.getColumns() == null) {
            this.setColumns(new ArrayList());
        }
        this.getColumns().add(column);
    }

    private StringBuffer createStatement(StringBuffer sb) throws SquelerDDLException {
        sb.append("ADD ");
        if (!StringHelper.isEmpty((String)this.getName()) && !"PRIMARY".equals(this.getName())) {
            sb.append("CONSTRAINT ").append(this.getName());
        }
        sb.append(" ").append(this.getType()).append(" ");
        if (this.getType() == "PRIMARY KEY") {
            if (this.getColumns() == null) {
                throw new SquelerDDLException(this.getType(), this.getName(), "No columns set for {type}");
            }
            sb.append("(");
            for (int i = 0; i < this.getColumns().size(); ++i) {
                ColumnDDL column = new ColumnDDL((ColumnModel)this.getColumns().get(i));
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(column.getName());
            }
            sb.append(")");
        } else if (this.getType() == "FOREIGN KEY") {
            if (this.getColumns() == null) {
                throw new SquelerDDLException(this.getType(), this.getName(), "No columns set for {type}");
            }
            StringBuffer ref = new StringBuffer();
            int refCnt = 0;
            int cnt = 0;
            ref.append(" REFERENCES ").append(this.getRecord().getString("TABLE_NAME")).append("(");
            sb.append("(");
            for (int i = 0; i < this.getColumns().size(); ++i) {
                ColumnDDL column = (ColumnDDL)this.getColumns().get(i);
                if (!column.getTableName().equals(this.getRecord().getString("TABLE_NAME"))) {
                    if (refCnt != 0) {
                        sb.append(", ");
                    }
                    ref.append(column.getName());
                    ++refCnt;
                    continue;
                }
                if (cnt != 0) {
                    sb.append(", ");
                }
                sb.append(column.getName());
                ++cnt;
            }
            ref.append(")");
            sb.append(") ").append(ref.toString());
        } else if (this.getType() == "CHECK") {
            sb.append(this.getRecord().getString("RULE"));
        }
        return sb;
    }

    private StringBuffer dropStatement(StringBuffer sb) {
        sb.append("DROP ");
        if (!StringHelper.isEmpty((String)this.getName()) && !"PRIMARY".equals(this.getName())) {
            sb.append("CONSTRAINT ").append(this.getName());
        } else {
            sb.append(this.getType());
        }
        return sb;
    }

    private StringBuffer alterStatement(StringBuffer sb) {
        sb.append("ENABLE CONSTRAINT ").append(this.getName());
        return sb;
    }

    public String toString() {
        try {
            return this.getStatement().toString();
        }
        catch (SquelerDDLException sqex) {
            return sqex.getMessage();
        }
    }

    public void setColumns(List columns) {
        super.setColumns(columns);
    }
}

