/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.squeler.ddl;

import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLMetaModel;
import org.brains2b.squeler.ddl.DDLDefinition;
import org.brains2b.squeler.ddl.SquelerDDLException;

public class ColumnDDL
extends ColumnModel
implements DDLDefinition {
    private boolean m_descendingSort = false;
    private int m_action;

    public ColumnDDL() {
        SQLRecord record = new SQLRecord(13);
        record.setColumn(0, "TYPE", String.class, (Object)"COLUMN");
        record.setColumn(1, "ORDINAL_POSITION", Integer.class);
        record.setColumn(2, "COLUMN_NAME", String.class);
        record.setColumn(3, "TABLE_CAT", String.class);
        record.setColumn(4, "TABLE_SCHEM", String.class);
        record.setColumn(5, "TABLE_NAME", String.class);
        record.setColumn(6, "DATA_TYPE", Integer.class);
        record.setColumn(7, "TYPE_NAME", String.class);
        record.setColumn(8, "COLUMN_SIZE", Integer.class);
        record.setColumn(9, "DECIMAL_DIGITS", Integer.class);
        record.setColumn(10, "IS_NULLABLE", String.class);
        record.setColumn(11, "COLUMN_DEF", String.class);
        record.setColumn(12, "REMARKS", String.class);
        this.setRecord(record);
    }

    public ColumnDDL(ColumnModel model) {
        this.setModel((SQLMetaModel)model);
    }

    public ColumnDDL(String columnName, int dataType, String typeName, int columnSize, int decimalDigits, String dflt, boolean nullable) {
        SQLRecord record = new SQLRecord(10);
        record.setColumn(0, "TYPE", String.class, (Object)"COLUMN");
        record.setColumn(1, "COLUMN_NAME", String.class, (Object)columnName);
        record.setColumn(2, "TABLE_CAT", String.class);
        record.setColumn(3, "TABLE_SCHEM", String.class);
        record.setColumn(4, "TABLE_NAME", String.class);
        record.setColumn(5, "DATA_TYPE", Integer.class, (Object)new Integer(dataType));
        record.setColumn(6, "TYPE_NAME", String.class, (Object)typeName);
        record.setColumn(7, "COLUMN_SIZE", Integer.class, (Object)new Integer(columnSize));
        record.setColumn(8, "DECIMAL_DIGITS", Integer.class, (Object)new Integer(decimalDigits));
        record.setColumn(9, "IS_NULLABLE", String.class);
        record.setColumn(10, "COLUMN_DEF", String.class, (Object)dflt);
        this.setRecord(record);
        this.setNullable(nullable);
    }

    public StringBuffer getStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(this.getRecord().getString("TABLE_NAME"));
        switch (this.getAction()) {
            case 3: {
                return this.modifyStatement(" MODIFY ", sb);
            }
            case 4: {
                return this.dropStatement(sb);
            }
        }
        return this.modifyStatement(" ADD ", sb);
    }

    public StringBuffer getStatement(String type, int action) throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        if (type.equals("TABLE")) {
            this.modifyStatement(null, sb);
        } else if (type.equals("INDEX")) {
            sb.append(this.getName());
            if (this.isDescendingSort()) {
                sb.append(" DESC");
            }
        }
        return sb;
    }

    public String getTypeName() {
        return this.getRecord().getString("TYPE_NAME");
    }

    public void setTableName(String tableName) {
        this.getRecord().setValue("TABLE_NAME", (Object)tableName);
    }

    public void setColumnName(String columnName) {
        this.getRecord().setValue("COLUMN_NAME", (Object)columnName);
    }

    public void setColumnSize(int size) {
        this.getRecord().setValue("COLUMN_SIZE", (Object)new Integer(size));
    }

    public void setDataType(short dataType) {
        this.getRecord().setValue("DATA_TYPE", (Object)new Integer(dataType));
    }

    public void setTypeName(String typeName) {
        this.getRecord().setValue("TYPE_NAME", (Object)typeName);
    }

    public void setDecimalDigits(int decimals) {
        this.getRecord().setValue("DECIMAL_DIGITS", (Object)new Integer(decimals));
    }

    public void setNullable(boolean nullable) {
        this.getRecord().setValue("IS_NULLABLE", (Object)(nullable ? "YES" : "NO"));
    }

    public boolean isNullable() {
        return !"NO".equals(this.getRecord().getString("IS_NULLABLE"));
    }

    public boolean isDescendingSort() {
        return this.m_descendingSort;
    }

    public void setDescendingSort(boolean descendingSort) {
        this.m_descendingSort = descendingSort;
    }

    public String toString() {
        try {
            return this.getStatement().toString();
        }
        catch (SquelerDDLException sqex) {
            return sqex.getMessage();
        }
    }

    public int getAction() {
        return this.m_action;
    }

    public boolean isQualified() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public void setModel(SQLMetaModel model) {
        if (!(model instanceof ColumnModel)) {
            throw new IllegalArgumentException("Cannot create ColumnDDL on non ColumnModel");
        }
        this.setRecord(model.getRecord());
    }

    private StringBuffer modifyStatement(String action, StringBuffer sb) throws SquelerDDLException {
        if (action != null) {
            sb.append(action).append(" ");
        }
        sb.append(this.getName());
        sb.append(" ");
        sb.append(this.getTypeName());
        int dataType = this.getRecord().getIntValue("DATA_TYPE");
        if (dataType != 91 && dataType != 93 && dataType != 2005 && dataType != 2004) {
            sb.append("(");
            sb.append(this.getRecord().getIntValue("COLUMN_SIZE"));
            if (this.getRecord().getIntValue("DECIMAL_DIGITS") > 0) {
                sb.append(", ").append(this.getRecord().getIntValue("DECIMAL_DIGITS"));
            }
            sb.append(")");
        }
        if (this.getDefault() != null && this.getDefault().length() > 0) {
            sb.append(" DEFAULT ");
            if (this.getDataType() == 12 || this.getDataType() == 1) {
                sb.append('\'').append(this.getDefault()).append('\'');
            } else {
                sb.append(this.getDefault());
            }
        }
        if (!this.isNullable()) {
            sb.append(" NOT NULL");
        }
        return sb;
    }

    private StringBuffer dropStatement(StringBuffer sb) throws SquelerDDLException {
        sb.append(" DROP COLUMN ").append(this.getName());
        return sb;
    }
}

