/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.squeler.ddl;

import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ProcedureModel;
import org.brains2b.sql.meta.SQLMetaModel;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.squeler.ddl.DDLDefinition;
import org.brains2b.squeler.ddl.SquelerDDLException;
import org.brains2b.util.StringHelper;

public class CodeDDL
implements DDLDefinition {
    private SQLRecord m_record;
    private int m_action;
    private boolean m_useHeader;
    private boolean m_replaceable;

    public CodeDDL() {
        this(null, null, null, true, false);
    }

    public CodeDDL(SQLRecord record) {
        this.m_record = record;
    }

    public CodeDDL(String type, String name, String text, boolean useHeader, boolean replaceable) {
        this.m_record = new SQLRecord(3);
        this.m_record.setColumn(0, "TYPE", String.class, (Object)type);
        this.m_record.setColumn(1, "NAME", String.class, (Object)name);
        this.m_record.setColumn(2, "TEXT", String.class, (Object)text);
        this.m_useHeader = useHeader;
        this.m_replaceable = replaceable;
    }

    public StringBuffer getStatement() throws SquelerDDLException {
        StringBuffer sb = new StringBuffer();
        if (StringHelper.isEmpty((String)this.getName()) || StringHelper.isEmpty((String)this.getName())) {
            return sb;
        }
        switch (this.getAction()) {
            case 4: {
                sb.append("DROP ").append(this.getType()).append(" ").append(this.getName());
                break;
            }
            default: {
                sb.append("CREATE ");
                if (this.isReplaceable()) {
                    sb.append("OR REPLACE ");
                }
                if (this.isUseHeader()) {
                    String start = "";
                    if ("VIEW".equals(this.getType())) {
                        start = " AS ";
                    } else if (!"TRIGGER".equals(this.getType())) {
                        start = " IS ";
                    }
                    sb.append(this.getType()).append(" ").append(this.getName()).append(start).append("\n");
                }
                if (this.getText() == null) break;
                sb.append(this.getText());
            }
        }
        return sb;
    }

    public String getName() {
        return this.m_record.getString("NAME");
    }

    public void setName(String name) {
        this.m_record.setValue("NAME", (Object)name);
    }

    public String getText() {
        return this.m_record.getString("TEXT");
    }

    public void setText(String text) {
        this.m_record.setValue("TEXT", (Object)text);
    }

    public String getType() {
        return this.m_record.getString("TYPE");
    }

    public void setType(String type) {
        this.m_record.setValue("TYPE", (Object)type);
    }

    public boolean isUseHeader() {
        return this.m_useHeader;
    }

    public void setUseHeader(boolean useHeader) {
        this.m_useHeader = useHeader;
    }

    public boolean isReplaceable() {
        return this.m_replaceable;
    }

    public void setReplaceable(boolean replaceable) {
        this.m_replaceable = replaceable;
    }

    public String toString() {
        try {
            return this.getStatement().toString();
        }
        catch (SquelerDDLException sqex) {
            return super.toString();
        }
    }

    public int getAction() {
        return this.m_action;
    }

    public boolean isQualified() {
        return false;
    }

    public void setAction(int action) {
        this.m_action = action;
    }

    public void setModel(SQLMetaModel model) {
        this.m_record = model.getRecord();
        if (model instanceof TableModel) {
            int idx = this.m_record.getIndex("TABLE_NAME");
            this.m_record.setColumn(idx, "NAME");
            idx = this.m_record.getIndex("TABLE_TYPE");
            this.m_record.setColumn(idx, "TYPE");
        } else if (model instanceof ProcedureModel) {
            int idx = this.m_record.getIndex("PROCEDURE_NAME");
            this.m_record.setColumn(idx, "NAME");
        }
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }
}

