/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DynamicClassLoader {
    public static final char FILESEP = System.getProperty("file.separator").charAt(0);

    public static final Class loadClass(String name, URL[] url) throws ClassNotFoundException {
        if (url == null) {
            return Class.forName(name);
        }
        URLClassLoader loader = URLClassLoader.newInstance(url);
        return DynamicClassLoader.loadClass(name, loader);
    }

    private static final Class loadClass(String name, URLClassLoader loader) throws ClassNotFoundException {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException cnfex) {
            Class<?> c = loader.loadClass(name);
            if (c == null) {
                throw new ClassNotFoundException(name + " cannot be found.");
            }
            return c;
        }
    }

    public static final Class[] loadClasses(URL[] url) throws ClassNotFoundException {
        ArrayList l = new ArrayList();
        for (int i = 0; i < url.length; ++i) {
            File f = new File(url[i].getPath());
            if (f.isDirectory()) {
                l.addAll(DynamicClassLoader.loadDir(f, f));
                continue;
            }
            l.addAll(DynamicClassLoader.loadArchive(f));
        }
        Class[] classes = new Class[l.size()];
        l.toArray(classes);
        return classes;
    }

    public static final Class[] findImplementation(Class superOrInterface, URL[] url) throws ClassNotFoundException {
        ArrayList<Class> l = new ArrayList<Class>();
        Class[] all = DynamicClassLoader.loadClasses(url);
        for (int i = 0; i < all.length; ++i) {
            if (!superOrInterface.isAssignableFrom(all[i])) continue;
            l.add(all[i]);
        }
        Class[] result = new Class[l.size()];
        l.toArray(result);
        return result;
    }

    private static final ArrayList loadDir(File parent, File f) throws ClassNotFoundException {
        ArrayList<Class> l = new ArrayList<Class>();
        File[] fs = f.listFiles();
        try {
            URLClassLoader loader = URLClassLoader.newInstance(new URL[]{f.toURL()});
            if (fs != null) {
                for (int i = 0; i < fs.length; ++i) {
                    if (fs[i].isDirectory()) {
                        l.addAll(DynamicClassLoader.loadDir(parent, fs[i]));
                        continue;
                    }
                    if (!fs[i].isFile() || !fs[i].getName().endsWith(".class")) continue;
                    String className = fs[i].getAbsolutePath().substring(parent.getAbsolutePath().length() + 1);
                    className = className.substring(0, className.length() - 6);
                    className = className.replace(FILESEP, '.');
                    try {
                        Class clazz = DynamicClassLoader.loadClass(className, loader);
                        if (l.contains(clazz)) continue;
                        l.add(clazz);
                        continue;
                    }
                    catch (NoClassDefFoundError ncdef) {
                        // empty catch block
                    }
                }
            }
        }
        catch (MalformedURLException mfuex) {
            // empty catch block
        }
        return l;
    }

    private static final ArrayList loadArchive(File f) throws ClassNotFoundException {
        ArrayList<Class> l = new ArrayList<Class>();
        try {
            URLClassLoader loader = URLClassLoader.newInstance(new URL[]{f.toURL()});
            ZipFile zf = new ZipFile(f);
            Enumeration<? extends ZipEntry> enu = zf.entries();
            while (enu.hasMoreElements()) {
                ZipEntry e = enu.nextElement();
                if (!e.getName().endsWith(".class")) continue;
                String className = e.getName();
                className = className.substring(0, className.length() - 6);
                className = className.replace('/', '.');
                try {
                    Class clazz = DynamicClassLoader.loadClass(className, loader);
                    l.add(clazz);
                }
                catch (NoClassDefFoundError ncdef) {}
            }
        }
        catch (MalformedURLException muex) {
        }
        catch (ZipException zex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return l;
    }
}

