/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.brains2b.console.ArgumentException;

public class ArgumentMap {
    private ArrayList m_args = new ArrayList();

    public void addArgument(String name, boolean required) {
        ArgumentEntry entry = new ArgumentEntry(name, '0', required, null);
        this.m_args.add(entry);
    }

    public void addArgument(String name, String defaultValue) {
        ArgumentEntry arg = new ArgumentEntry(name, '0', true, null);
        arg.setDefaultValue(defaultValue);
        this.m_args.add(arg);
    }

    public void addOption(String longKey, char shortKey, boolean required) {
        this.m_args.add(new ArgumentEntry(longKey, shortKey, required, null));
    }

    public void addArgumentTo(String option, String name, boolean required) {
        this.m_args.add(new ArgumentEntry(name, '0', required, option));
        this.getEntry(option).addChild(name);
    }

    public void addOptionTo(String argument, String longKey, char shortKey) {
        this.m_args.add(new ArgumentEntry(longKey, shortKey, false, argument));
        this.getEntry(argument).addChild(longKey);
    }

    public Map getList(String[] args) throws ArgumentException {
        HashMap<String, String> list = new HashMap<String, String>();
        this.processArgs(args);
        Iterator it = this.m_args.iterator();
        while (it.hasNext()) {
            ArgumentEntry entry = (ArgumentEntry)it.next();
            if (entry.getParent() == null && entry.getValue() != null) {
                list.put(entry.getName(), entry.getValue());
                continue;
            }
            if (entry.getParent() != null || !entry.isRequired()) continue;
            throw new ArgumentException(entry.getName(), "A required argument is missing");
        }
        return list;
    }

    private boolean isLong(String arg) {
        return arg.charAt(0) == '-' && arg.charAt(1) == '-';
    }

    private void processArgs(String[] args) throws ArgumentException {
        int size = args.length;
        for (int idx = 0; idx < size; ++idx) {
            ArgumentEntry arg = null;
            if (this.isLong(args[idx])) {
                arg = this.findLong(args[idx]);
                if (arg != null && this.processArg(arg, idx + 1 < size ? args[idx + 1] : null)) {
                    ++idx;
                }
            } else if (this.isShort(args[idx])) {
                for (int i = 1; i < args[idx].length(); ++i) {
                    arg = this.findShort(args[idx], i);
                    if (arg == null || !this.processArg(arg, idx + 1 < size ? args[idx + 1] : null)) continue;
                    ++idx;
                    break;
                }
            } else {
                arg = this.findNextWord();
                if (arg != null) {
                    arg.setValue(args[idx]);
                }
            }
            if (arg != null) continue;
            throw new ArgumentException(args[idx], "Not recognized as an argument");
        }
    }

    private boolean processArg(ArgumentEntry arg, String nextArg) throws ArgumentException {
        if (arg.getChildren() != null) {
            ArgumentEntry child = this.getEntry((String)arg.getChildren().get(0));
            if (nextArg != null && !this.isLong(nextArg) && !this.isShort(nextArg)) {
                arg.setValue(nextArg);
                return true;
            }
            if (child.isRequired()) {
                throw new ArgumentException(arg.getParent(), "A required argument is missing");
            }
        } else if (arg.getParent() != null) {
            ArgumentEntry parent = this.getEntry(arg.getParent());
            if (parent.getValue() == null || parent.getValue() == parent.getDefaultValue()) {
                parent.setValue(arg.getName());
            }
        } else {
            arg.setValue("true");
        }
        return false;
    }

    private boolean isShort(String arg) {
        return arg.charAt(0) == '-' && Character.isLetterOrDigit(arg.charAt(1));
    }

    private ArgumentEntry findLong(String arg) {
        return this.getEntry(arg.substring(2));
    }

    private ArgumentEntry findShort(String arg, int pos) {
        char a = arg.charAt(pos);
        Iterator it = this.m_args.iterator();
        while (it.hasNext()) {
            ArgumentEntry entry = (ArgumentEntry)it.next();
            if (entry.getShortKey() != a) continue;
            return entry;
        }
        return null;
    }

    private ArgumentEntry findNextWord() {
        Iterator it = this.m_args.iterator();
        while (it.hasNext()) {
            ArgumentEntry entry = (ArgumentEntry)it.next();
            if (entry.getShortKey() != '0' || entry.getParent() != null || entry.getChildren() != null || entry.getValue() != null) continue;
            return entry;
        }
        return null;
    }

    private final ArgumentEntry getEntry(String key) {
        Iterator it = this.m_args.iterator();
        while (it.hasNext()) {
            ArgumentEntry entry = (ArgumentEntry)it.next();
            if (!key.equals(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    class ArgumentEntry {
        private String m_name;
        private char m_shortKey;
        private boolean m_required;
        private String m_parent;
        private String m_default;
        private String m_value;
        private ArrayList m_children;

        public ArgumentEntry(String name, char shortKey, boolean required, String parent) {
            this.m_name = name;
            this.m_shortKey = shortKey;
            this.m_required = required;
            this.m_parent = parent;
        }

        public char getShortKey() {
            return this.m_shortKey;
        }

        public void addChild(String name) {
            if (this.m_children == null) {
                this.m_children = new ArrayList();
            }
            this.m_children.add(name);
        }

        public List getChildren() {
            return this.m_children;
        }

        public String getName() {
            return this.m_name;
        }

        public String getParent() {
            return this.m_parent;
        }

        public String getDefaultValue() {
            return this.m_default;
        }

        public String getValue() {
            return this.m_value;
        }

        public void setValue(String value) {
            this.m_value = value;
        }

        public void setDefaultValue(String value) {
            this.m_default = value;
            this.m_value = value;
        }

        public boolean isRequired() {
            return this.m_required;
        }
    }
}

