/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.brains2b.collection.MapEntry;

public class SortedMap
implements Map,
Comparator,
Serializable {
    public static final int KEY = 0;
    public static final int VALUE = 1;
    public static final int NO_SORT = -1;
    private ArrayList m_content = new ArrayList();
    private int m_sortOrder = 0;
    private transient Collection m_values = null;
    private transient Set m_keys = null;

    public SortedMap(int sortOrder) {
        this.m_sortOrder = sortOrder;
    }

    public SortedMap() {
        this(-1);
    }

    public SortedMap(Map map, int sortOrder) {
        this(sortOrder);
        this.putAll(map);
    }

    public SortedMap(Map map) {
        this(map, -1);
    }

    public SortedMap(Hashtable ht) {
        this(ht, 0);
    }

    public int getSortOrder() {
        return this.m_sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        if (sortOrder != 0 && sortOrder != 1 && sortOrder != -1) {
            throw new IllegalArgumentException("sortOrder must be either KEY|VALUE|NO_SORT");
        }
        this.m_sortOrder = sortOrder;
    }

    public int compare(Object oLeft, Object oRight) {
        if (this.m_sortOrder == -1) {
            return 1;
        }
        int result = -1;
        if (oLeft instanceof Map.Entry && oRight instanceof Map.Entry) {
            String right;
            String left;
            if (this.m_sortOrder == 0) {
                left = ((Map.Entry)oLeft).getKey().toString();
                right = ((Map.Entry)oRight).getKey().toString();
            } else {
                left = ((Map.Entry)oLeft).getValue().toString();
                if (left.compareTo(right = ((Map.Entry)oRight).getValue().toString()) == 0) {
                    left = ((Map.Entry)oLeft).getKey().toString();
                    right = ((Map.Entry)oRight).getKey().toString();
                }
            }
            result = left.compareTo(right);
        }
        if (!(oLeft instanceof Map.Entry) || oLeft == null) {
            result = 1;
        }
        return result;
    }

    public Set entrySet() {
        TreeSet ts = new TreeSet(this);
        ts.addAll(this.m_content);
        return ts;
    }

    public Object get(Object key) {
        Object result = null;
        if (key == null) {
            return null;
        }
        Iterator it = this.m_content.iterator();
        while (it.hasNext()) {
            MapEntry e = (MapEntry)it.next();
            if (!key.equals(e.getKey())) continue;
            result = e.getValue();
        }
        return result;
    }

    public Object put(Object key, Object value) {
        if (value == null || key == null) {
            return null;
        }
        Object old = null;
        MapEntry se = new MapEntry(key, value);
        int idx = this.m_content.indexOf(se);
        if (idx == -1) {
            this.m_content.add(se);
        } else {
            old = ((MapEntry)this.m_content.get(idx)).getValue();
            ((MapEntry)this.m_content.get(idx)).setValue(value);
        }
        return old;
    }

    public void putAll(Map m) {
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            this.put(o, m.get(o));
        }
    }

    public Object remove(Object key) {
        MapEntry se = new MapEntry(key, key);
        Object value = null;
        int idx = this.m_content.indexOf(se);
        if (idx != -1) {
            value = ((MapEntry)this.m_content.get(idx)).getValue();
            this.m_content.remove(se);
        }
        return value;
    }

    public void clear() {
        this.m_content.clear();
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Iterator it = this.m_content.iterator();
        while (it.hasNext()) {
            MapEntry e = (MapEntry)it.next();
            if (!value.equals(e.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.m_content.isEmpty();
    }

    public Set keySet() {
        if (this.m_keys == null) {
            this.m_keys = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = SortedMap.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getKey();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return SortedMap.this.size();
                }

                public boolean contains(Object k) {
                    return SortedMap.this.containsKey(k);
                }
            };
        }
        return this.m_keys;
    }

    public int size() {
        return this.m_content.size();
    }

    public Collection values() {
        if (this.m_values == null) {
            this.m_values = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = SortedMap.this.entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                public int size() {
                    return SortedMap.this.m_content.size();
                }

                public boolean contains(Object o) {
                    return SortedMap.this.containsValue(o);
                }
            };
        }
        return this.m_values;
    }
}

