/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.brains2b.log.Logger;
import org.brains2b.sql.meta.types.Stream;

public class TypesInfo {
    public static final TypesInfo DEFAULT = new TypesInfo();
    public static final int SMALLEST = 22;
    public static final int OPTIMIZE = 10;
    public static final int LARGE = 9;
    private int m_dataModel = 10;
    private HashMap m_types;
    private String m_dbUrl;

    TypesInfo() {
    }

    public TypesInfo(Connection connection) {
        try {
            this.setTargetTypes(connection);
            this.m_dbUrl = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            Logger.println((String)sQLException.getMessage(), (int)16);
        }
    }

    private void addTargetTypes(int n, String string) {
        if (this.m_types == null) {
            this.m_types = new HashMap();
        }
        if (!this.m_types.containsKey(new Integer(n))) {
            this.m_types.put(new Integer(n), string);
        }
    }

    public int getDataType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return -7;
        }
        if (clazz == Short.TYPE) {
            return 5;
        }
        if (clazz == Integer.TYPE) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE) {
            return 3;
        }
        if (clazz == String.class) {
            return 12;
        }
        if (clazz == Date.class) {
            return 91;
        }
        if (clazz == Timestamp.class) {
            return 93;
        }
        return 1111;
    }

    private String getDefaultDatatype(int n) {
        String string = null;
        switch (n) {
            case -7: 
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "NUMBER";
                break;
            }
            case 1: 
            case 12: {
                string = "VARCHAR2";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                string = "DATE";
                break;
            }
            case 1111: {
                string = "BLOB";
                break;
            }
            default: {
                string = "/* value: " + n + " cannot be determinend */";
            }
        }
        return string;
    }

    public String getJavaTypeName(int n, int n2, int n3) {
        String string = "";
        switch (n) {
            case -7: {
                string = "boolean";
                break;
            }
            case -6: {
                string = "short";
                break;
            }
            case 4: {
                string = "int";
                break;
            }
            case 5: {
                string = "short";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                if (n3 == 0) {
                    if (n2 < this.m_dataModel) {
                        string = "int";
                        break;
                    }
                    string = "long";
                    break;
                }
                if (n2 < 22 && n3 < this.m_dataModel) {
                    string = "double";
                    break;
                }
                string = "float";
                break;
            }
            case 1: {
                string = "String";
                break;
            }
            case 12: {
                string = "String";
                break;
            }
            case 91: {
                string = "Date";
                break;
            }
            case 92: 
            case 93: {
                string = "Timestamp";
                break;
            }
            case 1111: {
                string = "Object";
                break;
            }
            case -4: 
            case -1: {
                string = "Stream";
                break;
            }
            case 2005: {
                string = "Clob";
                break;
            }
            case 2004: {
                string = "Blob";
                break;
            }
            default: {
                string = "/* value: " + n + " cannot be determinend */";
            }
        }
        return string;
    }

    public boolean isPrimitive(int n) {
        return this.getJavaType(n, 0, 0).isPrimitive();
    }

    public Class getJavaType(int n, int n2, int n3) {
        Class<Object> clazz = null;
        switch (n) {
            case -7: {
                clazz = Boolean.TYPE;
                break;
            }
            case 4: {
                clazz = Integer.TYPE;
                break;
            }
            case -6: 
            case 5: {
                clazz = Short.TYPE;
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                if (n3 == 0) {
                    if (n2 < this.m_dataModel) {
                        clazz = Integer.TYPE;
                        break;
                    }
                    clazz = Long.TYPE;
                    break;
                }
                if (n2 < 22 && n3 < this.m_dataModel) {
                    clazz = Double.TYPE;
                    break;
                }
                clazz = Float.TYPE;
                break;
            }
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: 
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case 1111: {
                clazz = Object.class;
                break;
            }
            case -1: {
                clazz = Stream.class;
                break;
            }
            case -4: {
                clazz = Stream.class;
                break;
            }
            case 2005: {
                clazz = Clob.class;
                break;
            }
            case 2004: {
                clazz = Blob.class;
            }
            default: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    public String getLimitRows(int n) {
        if (this.m_dbUrl.indexOf("oracle") != -1) {
            return " WHERE ROWNUM < " + n;
        }
        return " LIMIT " + n;
    }

    public String getSQLType(int n) {
        String string = null;
        if (this.isTargetTypesSet()) {
            string = (String)this.m_types.get(new Integer(n));
        }
        if (string == null) {
            string = this.getDefaultDatatype(n);
        }
        return string;
    }

    public Collection getTypeNames() {
        if (this.isTargetTypesSet()) {
            return null;
        }
        return this.m_types.values();
    }

    public HashMap getTypes() {
        return this.m_types;
    }

    private final boolean isTargetTypesSet() {
        return this.m_types != null;
    }

    public void setDataModel(int n) {
        this.m_dataModel = n;
    }

    private final void setTargetTypes(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTypeInfo();
        while (resultSet.next()) {
            if (databaseMetaData.getDriverName().indexOf("Oracle") != -1 && resultSet.getInt("DATA_TYPE") == 93) {
                this.addTargetTypes(resultSet.getInt("DATA_TYPE"), "DATE");
                continue;
            }
            this.addTargetTypes(resultSet.getInt("DATA_TYPE"), resultSet.getString("TYPE_NAME"));
        }
        resultSet.close();
    }
}

