/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ConstraintModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class TableModel
implements SQLMetaModel {
    private SQLRecord m_record;
    private List m_columns;
    private List m_indices;
    private ConstraintModel m_primaryKey;

    protected TableModel() {
    }

    public TableModel(SQLRecord sQLRecord) {
        this.m_record = sQLRecord;
    }

    public String getName() {
        return this.m_record.getString("TABLE_NAME");
    }

    public String getCatalog() {
        return this.m_record.getString("TABLE_CAT");
    }

    public String getSchema() {
        return this.m_record.getString("TABLE_SCHEM");
    }

    public String getRemarks() {
        return this.m_record.getString("REMARKS");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getType() {
        return this.m_record.getString("TABLE_TYPE");
    }

    public List getColumns() {
        return this.m_columns;
    }

    protected void setColumns(List list) {
        this.m_columns = list;
    }

    public List getIndices() {
        return this.m_indices;
    }

    protected void setIndices(List list) {
        this.m_indices = list;
    }

    protected void setPrimaryKey(ConstraintModel constraintModel) {
        if (constraintModel != null && constraintModel.getType() != "PRIMARY KEY") {
            throw new IllegalArgumentException("You can only set a primary key to the table");
        }
        this.m_primaryKey = constraintModel;
    }

    protected void setRecord(SQLRecord sQLRecord) {
        this.m_record = sQLRecord;
    }

    public ConstraintModel getPrimaryKey() {
        return this.m_primaryKey;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableModel)) {
            return false;
        }
        TableModel tableModel = (TableModel)object;
        boolean bl = this.m_record.equals(tableModel.getRecord());
        if (!bl || this.m_columns == null || this.m_columns.isEmpty()) {
            return bl;
        }
        List list = tableModel.getColumns();
        if (list == null || list.size() != this.m_columns.size()) {
            return false;
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            bl = this.m_columns.get(i).equals(list.get(i));
            if (bl) continue;
            return bl;
        }
        boolean bl2 = bl = this.m_primaryKey == null ? bl : this.m_primaryKey.equals(tableModel.getPrimaryKey());
        if (!bl || this.m_indices == null || this.m_indices.isEmpty()) {
            return bl;
        }
        List list2 = tableModel.getColumns();
        if (list2 == null || list2.size() != this.m_indices.size()) {
            return false;
        }
        for (int i = 0; i < this.m_indices.size(); ++i) {
            bl = this.m_indices.get(i).equals(list2.get(i));
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

