/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class IndexModel
implements SQLMetaModel {
    private SQLRecord m_record;
    private List m_columns;

    protected IndexModel() {
    }

    public IndexModel(SQLRecord sQLRecord) {
        this.m_record = sQLRecord;
    }

    public String getName() {
        return this.m_record.getString("INDEX_NAME");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getType() {
        return "INDEX";
    }

    public List getColumns() {
        return this.m_columns;
    }

    protected void setColumns(List list) {
        this.m_columns = list;
    }

    public String getTableName() {
        return this.m_record.getString("TABLE_NAME");
    }

    public boolean isUnique() {
        if (this.m_record.getValue("NON_UNIQUE") instanceof Integer || this.m_record.getValue("NON_UNIQUE") instanceof BigDecimal || this.m_record.getValue("NON_UNIQUE") instanceof Short) {
            return this.m_record.getIntValue("NON_UNIQUE") == 0;
        }
        return this.m_record.getBoolValue("NON_UNIQUE");
    }

    protected void addColumn(ColumnModel columnModel) {
        this.m_columns.add(columnModel);
    }

    void setColumn(int n, ColumnModel columnModel) {
        if (this.m_columns == null) {
            this.m_columns = new ArrayList();
        }
        this.m_columns.add(n - 1, columnModel);
    }

    protected void setRecord(SQLRecord sQLRecord) {
        this.m_record = sQLRecord;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IndexModel)) {
            return false;
        }
        IndexModel indexModel = (IndexModel)object;
        boolean bl = this.m_record.equals(indexModel.getRecord());
        if (!bl || this.m_columns == null || this.m_columns.isEmpty()) {
            return bl;
        }
        List list = indexModel.getColumns();
        if (list == null || list.size() != this.m_columns.size()) {
            return false;
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            bl = this.m_columns.get(i).equals(list.get(i));
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

