/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.meta;

import java.util.ArrayList;
import java.util.List;
import org.brains2b.sql.SQLRecord;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLMetaModel;

public class ConstraintModel
implements SQLMetaModel {
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String FOREIGN_KEY = "FOREIGN KEY";
    public static final String CHECK = "CHECK";
    private SQLRecord m_record;
    private List m_columns;

    protected ConstraintModel() {
    }

    public ConstraintModel(String string, SQLRecord sQLRecord) {
        if (!(PRIMARY_KEY.equals(string) || FOREIGN_KEY.equals(string) || CHECK.equals(string))) {
            throw new IllegalArgumentException("Constraint type must be PRIMARY KEY, FOREIGN KEY or CHECK");
        }
        this.m_record = sQLRecord;
        this.m_record.setColumn(this.m_record.getColumnCount(), "TYPE", String.class, string);
    }

    public String getName() {
        return (String)this.m_record.getValue("NAME");
    }

    public SQLRecord getRecord() {
        return this.m_record;
    }

    public String getTableName() {
        return this.m_record.getString("TABLE_NAME");
    }

    public String getType() {
        return this.m_record.getString("TYPE");
    }

    public List getColumns() {
        return this.m_columns;
    }

    protected void setRecord(SQLRecord sQLRecord) {
        this.m_record = sQLRecord;
    }

    protected void setColumns(List list) {
        this.m_columns = list;
    }

    protected void addColumn(ColumnModel columnModel) {
        if (this.m_columns == null) {
            this.m_columns = new ArrayList();
        }
        this.m_columns.add(columnModel);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstraintModel)) {
            return false;
        }
        ConstraintModel constraintModel = (ConstraintModel)object;
        boolean bl = this.m_record.equals(constraintModel.getRecord());
        if (!bl || this.m_columns == null || this.m_columns.isEmpty()) {
            return bl;
        }
        List list = constraintModel.getColumns();
        if (list == null || list.size() != this.m_columns.size()) {
            return false;
        }
        for (int i = 0; i < this.m_columns.size(); ++i) {
            bl = this.m_columns.get(i).equals(list.get(i));
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

