/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class SQLRecord
implements Cloneable {
    private Object[] m_record;

    public SQLRecord() {
        this(0);
    }

    public SQLRecord(int n) {
        this.m_record = new Object[n];
    }

    public int getColumnCount() {
        return this.m_record.length / 3;
    }

    public void setColumn(int n, String string) {
        if (n >= this.m_record.length / 3) {
            this.resize(n + 1);
        }
        this.m_record[n * 3] = string;
    }

    public String getColumn(int n) {
        return (String)this.m_record[n * 3];
    }

    public void setColumnType(int n, Class clazz) {
        if (n >= this.m_record.length / 3) {
            this.resize(n + 1);
        }
        this.m_record[n * 3 + 1] = clazz;
    }

    public Class getColumnType(String string) {
        int n = this.getIndex(string);
        return (Class)this.m_record[n * 3 + 1];
    }

    public Class getColumnType(int n) {
        return (Class)this.m_record[n * 3 + 1];
    }

    public void setValue(int n, Object object) {
        if (n >= this.m_record.length / 3) {
            this.resize(n + 1);
        }
        this.m_record[n * 3 + 2] = object;
    }

    public void setValue(String string, Object object) {
        this.setValue(this.getIndex(string), object);
    }

    public void setColumn(int n, String string, Class clazz, Object object) {
        this.setColumn(n, string);
        this.setColumnType(n, clazz);
        this.setValue(n, object);
    }

    public void setColumn(int n, String string, Class clazz) {
        this.setColumn(n, string);
        this.setColumnType(n, clazz);
    }

    public Object getValue(int n) {
        return this.m_record[n * 3 + 2];
    }

    public boolean getBoolValue(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return false;
        }
        return this.getBoolValue(n);
    }

    public boolean getBoolValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new NumberFormatException("Value is not a boolean");
    }

    public double getDoubleValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public double getDoubleValue(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return 0.0;
        }
        return this.getDoubleValue(n);
    }

    public int getIntValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).intValue();
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Short) {
            return ((Short)object).intValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public long getLongValue(int n) {
        Object object = this.getValue(n);
        if (object == null) {
            return 0L;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).longValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public long getLongValue(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return 0L;
        }
        return this.getLongValue(n);
    }

    public String getString(String string) {
        return (String)this.getValue(string);
    }

    public String getString(int n) {
        return (String)this.getValue(n);
    }

    public Object getValue(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return null;
        }
        return this.m_record[n * 3 + 2];
    }

    public int getIntValue(String string) {
        int n = this.getIndex(string);
        if (n == -1) {
            return 0;
        }
        return this.getIntValue(n);
    }

    public int getIndex(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < this.m_record.length; i += 3) {
            if (!string.equalsIgnoreCase((String)this.m_record[i])) continue;
            return i / 3;
        }
        return -1;
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int hashCode() {
        int n = 13;
        for (int i = 0; i < this.m_record.length; ++i) {
            if (this.m_record[i] == null) continue;
            n += i * 43 + this.m_record[i].hashCode();
        }
        return n;
    }

    private final void resize(int n) {
        if (n <= this.m_record.length / 3) {
            return;
        }
        Object[] objectArray = new Object[n * 3];
        System.arraycopy(this.m_record, 0, objectArray, 0, this.m_record.length);
        this.m_record = objectArray;
    }

    public SQLRecord cloneDefinition() {
        SQLRecord sQLRecord = new SQLRecord(this.getColumnCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            sQLRecord.setColumn(i, this.getColumn(i), this.getColumnType(i));
        }
        return sQLRecord;
    }

    public Object clone() {
        SQLRecord sQLRecord = new SQLRecord(this.getColumnCount());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            sQLRecord.setColumn(i, this.getColumn(i), this.getColumnType(i), this.getValue(i));
        }
        return sQLRecord;
    }

    public static final SQLRecord createRecord(ResultSet resultSet) throws SQLException {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            SQLRecord sQLRecord = new SQLRecord(resultSetMetaData.getColumnCount());
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                sQLRecord.setColumn(i - 1, resultSetMetaData.getColumnName(i), Class.forName(resultSetMetaData.getColumnClassName(i)), resultSet.getObject(i));
            }
            return sQLRecord;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Cannot determine datatype for one of the fields");
        }
    }

    public static final SQLRecord createEmptyRecord(ResultSetMetaData resultSetMetaData) throws SQLException {
        try {
            SQLRecord sQLRecord = new SQLRecord(resultSetMetaData.getColumnCount());
            for (int i = 1; i < resultSetMetaData.getColumnCount() + 1; ++i) {
                sQLRecord.setColumn(i - 1, resultSetMetaData.getColumnName(i), Class.forName(resultSetMetaData.getColumnClassName(i)));
            }
            return sQLRecord;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Cannot determine datatype for one of the fields");
        }
    }
}

