/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.brains2b.loader.DynamicClassLoader;
import org.brains2b.sql.Connector;

public class LocalConnector
implements Connector {
    private Connection m_con;
    protected String m_url;
    protected Driver m_driver;
    protected Properties m_info;

    protected LocalConnector() {
    }

    public LocalConnector(String string, String string2, String string3, String string4) {
        this.init(null, string, string2, string3, string4);
    }

    public LocalConnector(String string, String string2, String string3, String string4, String string5) {
        this.init(string, string2, string3, string4, string5);
    }

    public Connection getConnection() throws SQLException {
        if (this.m_driver == null) {
            throw new SQLException("Cannot find driver");
        }
        if (this.m_con == null) {
            this.m_con = this.m_driver.connect(this.m_url, this.m_info);
        }
        return this.m_con;
    }

    public void close() throws SQLException {
        if (this.m_con != null) {
            this.m_con.close();
        }
        this.m_con = null;
    }

    protected void init(String string, String string2, String string3, String string4, String string5) {
        this.m_url = string3;
        this.m_info = new Properties();
        this.m_info.setProperty("user", string4);
        this.m_info.setProperty("password", string5);
        URL[] uRLArray = null;
        if (string != null) {
            uRLArray = this.makeClassPath(string);
        }
        try {
            Class clazz = DynamicClassLoader.loadClass(string2, uRLArray);
            this.m_driver = (Driver)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getUser() {
        String string = this.m_info.getProperty("user");
        if (this.m_url.indexOf("oracle") != -1) {
            return string.toUpperCase();
        }
        return string;
    }

    public String getDbName() {
        if (this.m_url != null) {
            int n = this.m_url.lastIndexOf(47) + 1;
            if (n == 0) {
                n = this.m_url.lastIndexOf(":") + 1;
            }
            return this.m_url.substring(n);
        }
        return null;
    }

    public String getServerName() {
        if (this.m_url != null) {
            int n;
            int n2 = this.m_url.lastIndexOf("@") + 1;
            if (n2 == 0) {
                n2 = this.m_url.indexOf("//") + 2;
            }
            if ((n = this.m_url.indexOf(":", n2)) == -1) {
                n = this.m_url.indexOf("/", n2);
            } else if (this.m_url.indexOf(46, n2) != -1) {
                n = this.m_url.indexOf(46, n2);
            }
            return this.m_url.substring(n2, n);
        }
        return null;
    }

    private URL[] makeClassPath(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.startsWith(System.getProperty("file.separator"))) {
                    uRLArray[n++] = new File(string2).toURL();
                    continue;
                }
                uRLArray[n++] = new File(System.getProperty("user.dir"), string2).toURL();
            }
            return uRLArray;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Object clone() {
        return new LocalConnector(this.m_driver.getClass().getName(), this.m_url, this.getUser(), this.m_info.getProperty("password"));
    }
}

