/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.typewriter;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.brains2b.typewriter.BlockTemplate;
import org.brains2b.typewriter.ContentTemplate;
import org.brains2b.typewriter.ExceptionTemplate;
import org.brains2b.typewriter.TypeWriterHelper;

public class TryTemplate
extends ContentTemplate {
    private List m_exceptions;
    private BlockTemplate m_final;

    public TryTemplate(Class clazz) {
        this(clazz.getName());
    }

    public TryTemplate(String string) {
        ExceptionTemplate exceptionTemplate = new ExceptionTemplate(string);
        exceptionTemplate.setParent(this.getParent());
        this.m_exceptions = new ArrayList();
        this.m_exceptions.add(exceptionTemplate);
    }

    public void write(PrintWriter printWriter, int n) {
        String string = TypeWriterHelper.spaces(n * 4);
        printWriter.print(string);
        printWriter.println("try {");
        super.write(printWriter, ++n);
        for (int i = 0; i < this.m_exceptions.size(); ++i) {
            ExceptionTemplate exceptionTemplate = (ExceptionTemplate)this.m_exceptions.get(i);
            exceptionTemplate.write(printWriter, n - 1);
            printWriter.print(string);
            if (i != this.m_exceptions.size() - 1) continue;
            if (this.m_final == null) {
                printWriter.println("}");
                continue;
            }
            printWriter.print("}");
        }
        if (this.m_final != null) {
            this.m_final.write(printWriter, n - 1);
        }
    }

    public ExceptionTemplate getDefaultException() {
        return (ExceptionTemplate)this.m_exceptions.get(0);
    }

    public ExceptionTemplate createException(String string) {
        ExceptionTemplate exceptionTemplate = new ExceptionTemplate(string);
        exceptionTemplate.setParent(this.getParent());
        this.m_exceptions.add(exceptionTemplate);
        return exceptionTemplate;
    }

    public BlockTemplate createFinally() {
        BlockTemplate blockTemplate;
        this.m_final = blockTemplate = new BlockTemplate("finally");
        return blockTemplate;
    }
}

