/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.typewriter;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.brains2b.typewriter.ClassTemplate;
import org.brains2b.typewriter.ContentTemplate;
import org.brains2b.typewriter.TypeWriterHelper;

public class MethodTemplate
extends ContentTemplate
implements Comparable {
    private String m_name;
    private String m_returnType;
    private String[] m_params;
    private String[] m_paramValues;
    private ArrayList m_exceptions;
    private int m_modifiers;
    private boolean m_constructor;

    public MethodTemplate(ClassTemplate classTemplate, int n, String string, String string2, String[] stringArray) {
        this.setParent(classTemplate);
        this.m_name = string;
        this.m_params = stringArray;
        this.m_returnType = string2;
        this.m_modifiers = n;
    }

    public MethodTemplate(ClassTemplate classTemplate, int n, String string, String string2, String[][] stringArray) {
        this.setParent(classTemplate);
        this.m_name = string;
        this.m_params = stringArray[0];
        this.m_paramValues = stringArray[1];
        this.m_returnType = string2;
        this.m_modifiers = n;
    }

    public void addException(String string) {
        String string2 = TypeWriterHelper.getClassName(string);
        if (this.m_exceptions == null) {
            this.m_exceptions = new ArrayList();
        }
        if (!this.m_exceptions.contains(string)) {
            this.m_exceptions.add(string2);
        }
    }

    public void invokeMethod(String string, String string2, Object object) {
        this.invokeMethod(string, string2, new Object[]{object});
    }

    public void invokeMethod(String string, String string2, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(".").append(string2);
        if (objectArray == null) {
            stringBuffer.append("();");
        } else {
            stringBuffer.append("( ");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i].toString());
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" );");
        }
        this.m_content.add(stringBuffer.toString());
    }

    public void write(PrintWriter printWriter, int n) {
        String string = TypeWriterHelper.spaces(n * 4);
        printWriter.print(string);
        printWriter.print(TypeWriterHelper.getModifiers(this.m_modifiers));
        if (!this.isConstructor()) {
            printWriter.print(this.m_returnType == null ? "void" : this.m_returnType);
            printWriter.print(" ");
        }
        printWriter.print(this.m_name);
        if (this.m_params == null) {
            printWriter.print("() ");
        } else {
            printWriter.print("(");
            for (int i = 0; i < this.m_params.length; ++i) {
                printWriter.print(this.m_params[i]);
                if (this.m_paramValues == null) {
                    printWriter.print(" arg" + i);
                } else {
                    printWriter.print(" " + this.m_paramValues[i]);
                }
                if (i >= this.m_params.length - 1) continue;
                printWriter.print(", ");
            }
            printWriter.print(") ");
        }
        if (this.m_exceptions != null && !this.m_exceptions.isEmpty()) {
            printWriter.print("throws ");
            Object[] objectArray = this.m_exceptions.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                printWriter.print(objectArray[i]);
                if (i + 1 < objectArray.length) {
                    printWriter.print(",");
                }
                printWriter.print(" ");
            }
        }
        printWriter.println("{");
        super.write(printWriter, n + 1);
        printWriter.print(string);
        printWriter.println("}");
    }

    public boolean isConstructor() {
        return this.m_constructor;
    }

    public void setConstructor(boolean bl) {
        this.m_constructor = bl;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof MethodTemplate) {
            MethodTemplate methodTemplate = (MethodTemplate)object;
            n = this.getCompareValue(this) - this.getCompareValue(methodTemplate);
            if (n == 0) {
                n = this.getName().compareTo(methodTemplate.getName());
            }
            if (n == 0) {
                if (this.m_params != null) {
                    if (methodTemplate.m_params != null) {
                        n = methodTemplate.m_params.length - this.m_params.length;
                        if (n == 0) {
                            for (int i = 0; i < this.m_params.length && (n = methodTemplate.m_params[i].compareTo(this.m_params[i])) == 0; ++i) {
                            }
                        }
                    } else {
                        n = 1;
                    }
                } else {
                    n = -1;
                }
            }
        } else {
            n = 1;
        }
        return n;
    }

    private int getCompareValue(MethodTemplate methodTemplate) {
        int n = 0;
        if (!methodTemplate.isConstructor()) {
            n += 8;
        }
        if (!Modifier.isStatic(methodTemplate.m_modifiers)) {
            n += 4;
        }
        if (Modifier.isProtected(methodTemplate.m_modifiers)) {
            n += 2;
        }
        if (Modifier.isPrivate(methodTemplate.m_modifiers)) {
            ++n;
        }
        return n;
    }

    public void setModifiers(int n) {
        this.m_modifiers = n;
    }

    public String getReturnType() {
        return this.m_returnType;
    }

    public void setReturnType(String string) {
        this.m_returnType = string;
    }
}

