/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.typewriter;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import org.brains2b.typewriter.ClassTemplate;
import org.brains2b.typewriter.Template;
import org.brains2b.typewriter.TypeWriterException;
import org.brains2b.typewriter.TypeWriterHelper;

public class MemberTemplate
implements Template {
    private ClassTemplate m_parent;
    private int m_modifiers;
    private String m_type;
    private String m_name;
    private Object m_initial;

    public MemberTemplate(String string, String string2) {
        this(2, string, string2, null);
    }

    public MemberTemplate(String string, String string2, Object object) {
        this(2, string, string2, object);
    }

    public MemberTemplate(int n, String string, String string2) {
        this(n, string, string2, null);
    }

    public MemberTemplate(int n, String string, String string2, Object object) {
        if (string == null || string.length() == 0) {
            throw new TypeWriterException("Member type must be supplied");
        }
        if (string2 == null || string2.length() == 0) {
            throw new TypeWriterException("Member name cannot be empty");
        }
        this.m_modifiers = n;
        this.m_type = string;
        this.m_name = string2;
        this.m_initial = object;
    }

    public void write(PrintWriter printWriter, int n) {
        if (Modifier.isStatic(this.m_modifiers) && Modifier.isFinal(this.m_modifiers) && this.m_initial == null) {
            throw new TypeWriterException("Cannot make a final static member without an initial value");
        }
        printWriter.print(TypeWriterHelper.spaces(n * 4));
        printWriter.print(TypeWriterHelper.getModifiers(this.m_modifiers));
        printWriter.print(this.m_type);
        printWriter.print(" ");
        printWriter.print(this.m_name);
        if (this.m_initial != null) {
            printWriter.print(" = ");
            printWriter.print(this.m_initial.toString());
        }
        printWriter.print(";");
    }

    public Object getInitialValue() {
        return this.m_initial;
    }

    public void setInitialValue(Object object) {
        this.m_initial = object;
    }

    public Template getParent() {
        return this.m_parent;
    }

    public void setParent(Template template) {
        this.m_parent = (ClassTemplate)template;
    }

    public void addImport(String string) {
        this.m_parent.addImport(string);
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String string) {
        this.m_type = string;
    }
}

