/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.typewriter;

import java.io.PrintWriter;
import org.brains2b.typewriter.BlockTemplate;
import org.brains2b.typewriter.ContentTemplate;
import org.brains2b.typewriter.TypeWriterException;
import org.brains2b.typewriter.TypeWriterHelper;
import org.brains2b.util.StringHelper;

public class IfTemplate
extends ContentTemplate {
    private String m_condition;
    private BlockTemplate m_elseT;

    public IfTemplate(String string) {
        this.m_condition = string;
    }

    public void write(PrintWriter printWriter, int n) {
        this.write(printWriter, n, true);
    }

    public void write(PrintWriter printWriter, int n, boolean bl) {
        if (StringHelper.isEmpty(this.m_condition)) {
            throw new TypeWriterException("cannot write an IfTemplate without a condition");
        }
        String string = TypeWriterHelper.spaces(n * 4);
        if (bl) {
            printWriter.print(string);
        }
        printWriter.print("if(");
        printWriter.print(this.m_condition);
        printWriter.println(") {");
        super.write(printWriter, n + 1);
        if (this.m_elseT == null) {
            printWriter.println(string + "}");
        } else if (this.m_elseT.getContent().size() == 1 && this.m_elseT.getContent().get(0) instanceof IfTemplate) {
            printWriter.print(string + "} else ");
            ((IfTemplate)this.m_elseT.getContent().get(0)).write(printWriter, n, false);
        } else {
            printWriter.print(string + "}");
            this.m_elseT.write(printWriter, n);
        }
    }

    public BlockTemplate createElse() {
        this.m_elseT = new BlockTemplate("else");
        this.m_elseT.setParent(this);
        return this.m_elseT;
    }

    public void setCondition(String string) {
        this.m_condition = string;
    }

    public String getCondition() {
        return this.m_condition;
    }
}

