/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.typewriter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.brains2b.typewriter.CommentTemplate;
import org.brains2b.typewriter.MemberTemplate;
import org.brains2b.typewriter.MethodTemplate;
import org.brains2b.typewriter.Template;
import org.brains2b.typewriter.TypeWriterHelper;
import org.brains2b.util.JavaHelper;

public class ClassTemplate
implements Template {
    private CommentTemplate m_comment;
    private ArrayList m_imports;
    private ArrayList m_interfaces;
    private HashMap m_methods;
    private HashMap m_members;
    private HashMap m_innerClasses;
    private String m_name;
    private String m_package;
    private String m_superclass;
    private File completeFile;
    private ClassTemplate m_parent;

    protected ClassTemplate(ClassTemplate classTemplate, String string, String string2, String[] stringArray) {
        this.m_parent = classTemplate;
        this.m_name = string;
        this.m_superclass = TypeWriterHelper.getClassName(string2);
        this.m_methods = new HashMap();
        this.m_members = new HashMap();
        this.m_innerClasses = new HashMap();
        this.m_imports = new ArrayList();
        this.m_interfaces = new ArrayList();
        this.addImport(string2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.addInterface(stringArray[i]);
            }
        }
    }

    public ClassTemplate(String string, String string2, String[] stringArray) {
        this((ClassTemplate)null, string, string2, stringArray);
    }

    public ClassTemplate(String string, String string2, String string3, String[] stringArray) {
        this((ClassTemplate)null, string2, string3, stringArray);
        this.setPackage(string);
    }

    public void write(PrintWriter printWriter, int n) {
        String string = TypeWriterHelper.spaces(n * 4);
        if (this.m_comment != null) {
            this.m_comment.write(printWriter, n);
        }
        boolean bl = false;
        if (this.m_package != null && this.m_parent == null) {
            printWriter.print("package ");
            printWriter.print(this.m_package);
            printWriter.println(";");
            printWriter.println();
            bl = true;
        }
        Collections.sort(this.m_imports);
        TreeSet treeSet = this.m_imports.iterator();
        while (treeSet.hasNext()) {
            printWriter.print("import ");
            printWriter.print(treeSet.next());
            printWriter.println(";");
        }
        if (!this.m_imports.isEmpty()) {
            printWriter.println();
            bl = true;
        }
        if (!bl && this.m_parent == null) {
            printWriter.println();
        }
        printWriter.print(string + "public class ");
        printWriter.print(this.m_name);
        if (this.m_superclass != null) {
            printWriter.print(" extends ");
            printWriter.print(this.m_superclass);
        }
        if (!this.m_interfaces.isEmpty()) {
            Collections.sort(this.m_interfaces);
            printWriter.print(" implements ");
            for (int i = 0; i < this.m_interfaces.size(); ++i) {
                printWriter.print(this.m_interfaces.get(i));
                if (i >= this.m_interfaces.size() - 1) continue;
                printWriter.print(", ");
            }
        }
        printWriter.println(" {");
        printWriter.println();
        treeSet = this.m_innerClasses.values().iterator();
        while (treeSet.hasNext()) {
            ((ClassTemplate)treeSet.next()).write(printWriter, n + 1);
            printWriter.println();
        }
        treeSet = new TreeSet(this.m_methods.values());
        Iterator<Object> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ((MethodTemplate)iterator.next()).write(printWriter, n + 1);
            printWriter.println();
        }
        treeSet = new TreeSet(this.m_members.keySet());
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ((MemberTemplate)this.m_members.get(iterator.next())).write(printWriter, n + 1);
            printWriter.println();
        }
        printWriter.println(string + "}");
    }

    public File getCompleteFile() {
        return this.completeFile;
    }

    public void writeClass(String string) throws IOException {
        if (this.m_name == null) {
            return;
        }
        File file = this.getPackageDir(new File(string), this.getPackage());
        this.completeFile = new File(file, this.m_name + ".java");
        FileWriter fileWriter = new FileWriter(this.completeFile);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        this.write(printWriter, 0);
        printWriter.close();
    }

    public ClassTemplate createInnerClass(String string, String string2, String[] stringArray) {
        ClassTemplate classTemplate = (ClassTemplate)this.m_innerClasses.get(string);
        if (classTemplate == null) {
            classTemplate = new ClassTemplate(this, string, string2, stringArray);
            this.m_innerClasses.put(string, classTemplate);
        }
        return classTemplate;
    }

    public CommentTemplate createComment() {
        this.m_comment = new CommentTemplate();
        return this.m_comment;
    }

    public MethodTemplate createConstructor(String[] stringArray) {
        MethodTemplate methodTemplate = new MethodTemplate(this, 1, this.m_name, null, stringArray);
        methodTemplate.setConstructor(true);
        this.m_methods.put(this.createSignature(this.m_name, stringArray), methodTemplate);
        return methodTemplate;
    }

    public MethodTemplate createConstructor(String[][] stringArray) {
        MethodTemplate methodTemplate = new MethodTemplate(this, 1, this.m_name, null, stringArray);
        methodTemplate.setConstructor(true);
        this.m_methods.put(this.createSignature(this.m_name, stringArray[0]), methodTemplate);
        return methodTemplate;
    }

    public MethodTemplate createMethod(String string, String[] stringArray) {
        return this.createMethod(1, string, null, stringArray);
    }

    public MethodTemplate createMethod(String string, String string2, String[] stringArray) {
        return this.createMethod(1, string, string2, stringArray);
    }

    public MethodTemplate createMethod(int n, String string, String string2, String[] stringArray) {
        String string3 = this.createSignature(string, stringArray);
        MethodTemplate methodTemplate = (MethodTemplate)this.m_methods.get(string3);
        if (methodTemplate == null) {
            methodTemplate = new MethodTemplate(this, n, string, string2, stringArray);
            this.m_methods.put(string3, methodTemplate);
        }
        return methodTemplate;
    }

    public MethodTemplate createMethod(int n, String string, String string2, String[][] stringArray) {
        String string3 = this.createSignature(string, stringArray[0]);
        MethodTemplate methodTemplate = (MethodTemplate)this.m_methods.get(string3);
        if (methodTemplate == null) {
            methodTemplate = new MethodTemplate(this, n, string, string2, stringArray);
            this.m_methods.put(string3, methodTemplate);
        }
        return methodTemplate;
    }

    public MemberTemplate createMember(String string, String string2, Object object) {
        MemberTemplate memberTemplate = (MemberTemplate)this.m_members.get(string2);
        if (memberTemplate == null) {
            memberTemplate = new MemberTemplate(TypeWriterHelper.getClassName(string), string2, object);
            this.m_members.put(string2, memberTemplate);
        }
        return memberTemplate;
    }

    public MemberTemplate createMember(int n, String string, String string2, Object object) {
        MemberTemplate memberTemplate = (MemberTemplate)this.m_members.get(string2);
        if (memberTemplate == null) {
            memberTemplate = new MemberTemplate(n, TypeWriterHelper.getClassName(string), string2, object);
            this.m_members.put(string2, memberTemplate);
        }
        return memberTemplate;
    }

    public MemberTemplate createMember(String string, String string2, Object object, boolean bl) {
        return this.createMember(2, string, string2, object);
    }

    public MemberTemplate createMember(String string, String string2) {
        return this.createMember(2, string, string2, null);
    }

    public void addInterface(String string) {
        if (string == null) {
            return;
        }
        if (!this.m_interfaces.contains(string)) {
            this.m_interfaces.add(TypeWriterHelper.getClassName(string));
            this.addImport(string);
        }
    }

    public void addImport(String string) {
        if (string == null || string.indexOf(46) == -1) {
            return;
        }
        if (this.getParent() != null) {
            ((ClassTemplate)this.getParent()).addImport(string);
        } else if (!this.m_imports.contains(string)) {
            this.m_imports.add(string);
        }
    }

    public Template getParent() {
        return this.m_parent;
    }

    public void setParent(Template template) {
        this.m_parent = (ClassTemplate)template;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPackage() {
        return this.m_package;
    }

    public void setPackage(String string) {
        this.m_package = string;
    }

    private File getPackageDir(File file, String string) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getCanonicalPath() + " is not found on this system");
        }
        if (string == null || string.length() == 0) {
            return file;
        }
        char c = System.getProperty("file.separator").charAt(0);
        File file2 = new File(file, string = string.replace('.', c));
        if (file2.exists() || file2.mkdirs()) {
            return file2;
        }
        throw new IOException("Creation of package " + string + " at " + file.getCanonicalPath() + "failed");
    }

    private String createSignature(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(JavaHelper.objectName(stringArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    public void setName(String string) {
        if (!this.m_name.equals(string)) {
            Iterator iterator = this.m_methods.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                MethodTemplate methodTemplate = (MethodTemplate)this.m_methods.get(string2);
                if (!string2.startsWith(this.m_name)) continue;
                string2.replaceFirst(this.m_name, string);
                methodTemplate.setName(string);
            }
            this.m_name = string;
        }
    }
}

