/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.toclass;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import org.brains2b.log.Logger;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.SQLKeyWords;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.sql.meta.TypesInfo;
import org.brains2b.task.DefaultTask;
import org.brains2b.typewriter.KeyWords;
import org.brains2b.util.JavaHelper;

public abstract class SqlClassWriter
extends DefaultTask {
    protected File m_location;
    protected String m_packageName;
    protected TableModel m_tableModel;
    protected TypesInfo m_typeInfo = TypesInfo.DEFAULT;

    protected SqlClassWriter(File file, String string) {
        this.m_location = file;
        this.m_packageName = string;
    }

    protected abstract String getClassName(String var1);

    public boolean fileExists(String string) {
        try {
            File file = this.getFile(this.m_location, this.m_packageName, this.getClassName(string));
            return this.isFileSame(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            Logger.printException(iOException);
            return true;
        }
    }

    public void setTableModel(TableModel tableModel) {
        this.m_tableModel = tableModel;
    }

    public void setTypeInfo(TypesInfo typesInfo) {
        this.m_typeInfo = typesInfo;
    }

    protected File getFile(File file, String string, String string2) throws IOException {
        File file2 = null;
        file2 = file != null && string != null ? new File(this.createPackageDir(file, string), string2 + ".java") : (file != null ? new File(file, string2 + ".java") : new File(string2 + ".java"));
        return file2;
    }

    private File createPackageDir(File file, String string) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("location " + file + " does not exist");
        }
        if (string == null) {
            return file;
        }
        File file2 = new File(file, string = string.replace('.', '/'));
        if (file2.exists()) {
            return file2;
        }
        if (file2.mkdirs() && file2.exists()) {
            return file2;
        }
        throw new IOException("could not create directories for package");
    }

    protected boolean isPrimaryKey(ColumnModel columnModel, TableModel tableModel) {
        if (tableModel.getPrimaryKey() == null) {
            return false;
        }
        Iterator iterator = tableModel.getPrimaryKey().getColumns().iterator();
        while (iterator.hasNext()) {
            ColumnModel columnModel2 = (ColumnModel)iterator.next();
            if (!columnModel2.getName().equals(columnModel.getName()) || !columnModel2.getTableName().equals(columnModel.getTableName())) continue;
            return true;
        }
        return false;
    }

    private boolean isFileSame(File file) {
        boolean bl = true;
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                if (string != null && string.startsWith("/*") && bufferedReader.readLine().indexOf("$1.01$") == -1) {
                    bl = false;
                }
                while (string != null) {
                    if (string.indexOf("@#History") != -1) {
                        bl = true;
                        break;
                    }
                    if (string.startsWith("public class")) break;
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                Logger.printException(iOException);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected String getUnreserverdWord(String string) {
        if (string.endsWith("_X") && SQLKeyWords.isReserved(string.substring(0, string.length() - 2))) {
            return string.substring(0, string.length() - 2);
        }
        if (KeyWords.isMethodReserved((String)("get" + JavaHelper.objectName(string)))) {
            return string + "_X";
        }
        return string;
    }

    protected String varName(String string) {
        String string2 = string.substring(0, 1).toLowerCase() + string.substring(1);
        if (KeyWords.isReserved((String)string2)) {
            string2 = "x_" + string2;
        }
        return string2;
    }

    public abstract File getResultfile();
}

