/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.toclass;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.brains2b.log.Logger;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.sql.toclass.SqlClassWriter;
import org.brains2b.typewriter.ClassTemplate;
import org.brains2b.typewriter.CommentTemplate;
import org.brains2b.typewriter.IfTemplate;
import org.brains2b.typewriter.KeyWords;
import org.brains2b.typewriter.Literal;
import org.brains2b.typewriter.MethodTemplate;
import org.brains2b.util.JavaHelper;
import org.brains2b.util.StringHelper;

public class Sql2File
extends SqlClassWriter {
    private String className;
    private ClassTemplate classTemp;
    private String[][] members;
    private List tableColumns;
    private boolean optimisticLock;
    private boolean m_trimValue;
    private boolean m_default;
    private String[] m_keywords = new String[]{"SYSDATE", "new Timestamp(new java.util.Date().getTime())"};

    public Sql2File(File file, String string, TableModel tableModel) {
        super(file, string);
        this.setTableModel(tableModel);
        this.tableColumns = tableModel.getColumns();
    }

    public Sql2File(File file, String string) {
        super(file, string);
    }

    public void setTableModel(TableModel tableModel) {
        super.setTableModel(tableModel);
        this.tableColumns = tableModel.getColumns();
    }

    public void run() {
        this.className = this.getClassName(this.m_tableModel.getName());
        this.classTemp = new ClassTemplate(this.m_packageName, this.className, null, null);
        this.makeMembers();
        this.writeHeaderComment();
        this.writeDefaultConstructor();
        this.writeConstructor();
        this.writeAccessors();
        if (this.isOptimisticLock()) {
            this.classTemp.createMethod("serialID", "int", null).addText("return serialID;");
        }
        if (this.m_tableModel.getPrimaryKey() != null) {
            this.writeEquals();
        }
        this.writeHashCode();
        this.writeMembers();
        try {
            this.classTemp.writeClass(this.m_location.toString());
            Logger.println("data class saved as " + this.className + ".java");
            this.setResult(0);
        }
        catch (IOException iOException) {
            Logger.printException(iOException);
            this.setResult(1);
            this.addMessage(iOException.getMessage());
        }
        this.setFinished(true);
    }

    public File getResultfile() {
        return this.classTemp.getCompleteFile();
    }

    private void makeMembers() {
        this.members = new String[this.tableColumns.size()][4];
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            ColumnModel columnModel = (ColumnModel)this.tableColumns.get(i);
            String string = this.getUnreserverdWord(columnModel.getName());
            this.members[i][0] = JavaHelper.memberName(string);
            this.members[i][1] = JavaHelper.objectName(string);
            this.members[i][2] = columnModel.getName().equals("ROWID") ? "String" : this.m_typeInfo.getJavaTypeName(columnModel.getDataType(), columnModel.getColumnSize(), columnModel.getDecimalDigits());
            if (columnModel.getDefault() == null || columnModel.getDefault().indexOf(40) != -1 || "NULL".equals(columnModel.getDefault())) continue;
            if (!this.isKeyWord(columnModel.getDefault())) {
                this.members[i][3] = columnModel.getDefault() + ("long".equals(this.members[i][2]) ? "L" : ("double".equals(this.members[i][2]) ? "d" : ""));
                continue;
            }
            if (columnModel.getDefault().indexOf(40) != -1) continue;
            this.members[i][3] = this.getJavaForKeyWord(columnModel.getDefault());
        }
    }

    private void writeHeaderComment() {
        CommentTemplate commentTemplate = this.classTemp.createComment();
        commentTemplate.addText("$1.01$");
        commentTemplate.addText("Class " + this.className);
        commentTemplate.addText("Generated from table: " + this.m_tableModel.getName());
        commentTemplate.addText("Schema: " + this.m_tableModel.getSchema());
        commentTemplate.addText("Database: ");
        commentTemplate.addText("");
        commentTemplate.addText("@since: " + new Date().toString());
    }

    private void writeDefaultConstructor() {
        MethodTemplate methodTemplate = this.classTemp.createConstructor((String[])null);
        if (this.isOptimisticLock()) {
            methodTemplate.addText("serialID = hashCode();");
            methodTemplate.addText("m_checksum=serialID;");
        }
    }

    private void writeConstructor() {
        if (this.members.length > 126) {
            return;
        }
        String[][] stringArray = new String[2][this.members.length];
        for (int i = 0; i < this.members.length; ++i) {
            stringArray[0][i] = this.members[i][2];
            stringArray[1][i] = this.varName(this.members[i][1]);
        }
        MethodTemplate methodTemplate = this.classTemp.createConstructor(stringArray);
        if (this.isOptimisticLock()) {
            methodTemplate.addText("serialID = hashCode();");
        }
        for (int i = 0; i < this.members.length; ++i) {
            methodTemplate.addText(this.members[i][0] + " = " + this.varName(this.members[i][1]) + ";");
        }
    }

    private void writeAccessors() {
        if (this.isOptimisticLock()) {
            this.classTemp.addInterface("org.brains2b.data.OptimisticLock");
            this.writeGetter("m_checksum", "Checksum", "int");
            this.writeSetter("m_checksum", "Checksum", "int");
        }
        for (int i = 0; i < this.members.length; ++i) {
            String string = this.members[i][1];
            if (KeyWords.isMethodReserved((String)("get" + string))) {
                string = string + "X";
            }
            this.writeGetter(this.members[i][0], string, this.members[i][2]);
            this.writeSetter(this.members[i][0], string, this.members[i][2]);
            if ("Clob".equals(this.members[i][2]) || "Blob".equals(this.members[i][2])) {
                this.classTemp.addImport("java.sql." + this.members[i][2]);
            } else if ("Stream".equals(this.members[i][2])) {
                this.classTemp.addImport("org.brains2b.sql.meta.types.Stream");
            }
            if (this.members[i][2].equals("Timestamp")) {
                this.classTemp.addImport("java.sql.Timestamp");
                this.writeDateSetter("Timestamp", this.members[i][0], string, "java.util.Date");
            }
            if (!this.members[i][2].equals("Date")) continue;
            this.classTemp.addImport("java.sql.Date");
            this.writeDateSetter("Date", this.members[i][0], string, "java.util.Date");
        }
    }

    private void writeEquals() {
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "equals", "boolean", (String[][])new String[][]{{"Object"}, {"o"}});
        methodTemplate.addText("boolean result=false;");
        IfTemplate ifTemplate = methodTemplate.createIf("o instanceof " + this.className);
        ifTemplate.addText(this.className + " l = (" + this.className + ") o;");
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < this.tableColumns.size(); ++i) {
            ColumnModel columnModel = (ColumnModel)this.tableColumns.get(i);
            if (!this.isPrimaryKey(columnModel, this.m_tableModel)) continue;
            if (n > 0) {
                stringBuffer.append(" && ");
            }
            if (this.m_typeInfo.isPrimitive(columnModel.getDataType())) {
                stringBuffer.append(" this." + this.members[i][0] + " == l.get" + this.members[i][1] + "() ");
            } else {
                stringBuffer.append(" this." + this.members[i][0] + ".equals(l.get" + this.members[i][1] + "()) ");
            }
            ++n;
        }
        ifTemplate.createIf(stringBuffer.toString()).addText("result = true;");
        methodTemplate.addText("return result;");
    }

    private void writeMembers() {
        if (this.isOptimisticLock()) {
            this.classTemp.createMember("int", "m_checksum");
            this.classTemp.createMember(18, "int", "serialID", null);
        }
        for (int i = 0; i < this.members.length; ++i) {
            Object object = null;
            if (this.m_default && this.members[i][3] != null) {
                object = "String".equals(this.members[i][2]) ? new Literal(this.members[i][3]) : ("char".equals(this.members[i][2]) ? new Literal(this.members[i][3].charAt(0)) : this.members[i][3]);
            }
            this.classTemp.createMember(this.members[i][2], this.members[i][0], object);
        }
    }

    private void writeHashCode() {
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "hashCode", "int", (String[])null);
        methodTemplate.addImport("org.brains2b.data.HashCodeHelper");
        methodTemplate.addText("int hash=HashCodeHelper.INITIAL;");
        for (int i = 0; i < this.members.length; ++i) {
            methodTemplate.addText("hash = HashCodeHelper.hash(hash, get" + this.members[i][1] + "());");
        }
        methodTemplate.addText("return hash;");
    }

    private void writeGetter(String string, String string2, String string3) {
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "get" + string2, string3, (String[])null);
        if (this.m_trimValue && string3.equals("String")) {
            methodTemplate.createIf(string + " != null && " + string + ".trim().length()>0").addText("return " + string + ".trim();");
            methodTemplate.addText("return \" \";");
        } else {
            methodTemplate.addText("return " + string + ";");
        }
    }

    private void writeSetter(String string, String string2, String string3) {
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "set" + string2, "void", (String[][])new String[][]{{string3}, {this.varName(string2)}});
        methodTemplate.addText(string + " = " + this.varName(string2) + ";");
    }

    private void writeDateSetter(String string, String string2, String string3, String string4) {
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "set" + string3, "void", (String[][])new String[][]{{string4}, {this.varName(string3)}});
        IfTemplate ifTemplate = methodTemplate.createIf(this.varName(string3) + "!=null");
        ifTemplate.addText(string2 + "= new " + string + "((" + this.varName(string3) + ").getTime());");
        if (!string4.endsWith(string4)) {
            ifTemplate.addText(string2 + ".setNanos(0);");
        }
        ifTemplate.createElse().addText(string2 + " = null;");
    }

    protected String getClassName(String string) {
        string = this.getUnreserverdWord(string);
        return JavaHelper.objectName(string);
    }

    protected boolean isOptimisticLock() {
        return this.optimisticLock;
    }

    public void setOptimisticLock(boolean bl) {
        this.optimisticLock = bl;
    }

    public boolean isTrimValue() {
        return this.m_trimValue;
    }

    public void setTrimValue(boolean bl) {
        this.m_trimValue = bl;
    }

    public boolean isDefault() {
        return this.m_default;
    }

    public void setDefault(boolean bl) {
        this.m_default = bl;
    }

    private final boolean isKeyWord(String string) {
        if (StringHelper.isEmpty(string)) {
            return false;
        }
        String string2 = string.toUpperCase();
        for (int i = 0; i < this.m_keywords.length; i += 2) {
            if (!string2.equals(this.m_keywords[i])) continue;
            return true;
        }
        return false;
    }

    private final String getJavaForKeyWord(String string) {
        if (StringHelper.isEmpty(string)) {
            return null;
        }
        String string2 = string.toUpperCase();
        for (int i = 0; i < this.m_keywords.length; i += 2) {
            if (!string2.equals(this.m_keywords[i])) continue;
            return this.m_keywords[i + 1];
        }
        return null;
    }
}

