/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.toclass;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import org.brains2b.log.Logger;
import org.brains2b.sql.meta.ColumnModel;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.sql.toclass.SqlClassWriter;
import org.brains2b.typewriter.ClassTemplate;
import org.brains2b.typewriter.CommentTemplate;
import org.brains2b.typewriter.ContentTemplate;
import org.brains2b.typewriter.ExceptionTemplate;
import org.brains2b.typewriter.IfTemplate;
import org.brains2b.typewriter.MethodTemplate;
import org.brains2b.typewriter.TryTemplate;
import org.brains2b.util.JavaHelper;
import org.brains2b.util.StringHelper;

public class Sql2DataC
extends SqlClassWriter {
    private String m_name;
    private String m_objName;
    private String m_instance;
    private boolean m_readOnly;
    private boolean m_optimisticLock;
    private String m_database;
    private ClassTemplate classTemp;

    public Sql2DataC(File file, String string) {
        super(file, string);
    }

    public Sql2DataC(File file, String string, TableModel tableModel) {
        super(file, string);
        this.setTableModel(tableModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_tableModel != null) {
            boolean bl = this.isReadOnly() || this.m_tableModel.getType().equals("VIEW");
            try {
                this.m_name = this.getClassName(this.m_tableModel.getName());
                this.m_instance = this.varName(this.m_objName);
                this.classTemp = new ClassTemplate(this.m_packageName, this.m_name, "org.brains2b.data.sql.SqlDC", null);
                this.classTemp.addImport("java.util.List");
                this.classTemp.addImport("java.sql.ResultSet");
                this.classTemp.addImport("java.sql.Connection");
                this.classTemp.addImport("java.sql.SQLException");
                this.classTemp.addImport("org.brains2b.data.DataException");
                this.writeHeaderComment();
                this.progress();
                this.writeConstructor();
                this.progress();
                if (this.m_tableModel.getColumns().size() > 126) {
                    this.writeGetLargeObject();
                } else {
                    this.writeGetObject();
                }
                this.progress();
                if (bl) {
                    this.writeUpdateforReadOnly();
                } else {
                    this.writeUpdate();
                }
                this.progress();
                if (bl) {
                    this.writeInsertforReadOnly();
                } else {
                    this.writeInsert();
                }
                this.progress();
                if (bl) {
                    this.writeDeleteforReadOnly();
                } else {
                    this.writeDelete();
                }
                this.progress();
                if (this.getPrimaryKey(this.m_tableModel) != null) {
                    this.writeRetrieve();
                } else {
                    this.writeRetrieveNonPk();
                }
                this.progress();
                this.writeRetrieveList();
                this.progress();
                this.classTemp.writeClass(this.m_location.getAbsolutePath());
                Logger.println("datacontrol class saved as " + this.classTemp.getName() + ".java");
                this.setResult(0);
            }
            catch (Exception exception) {
                if (!"NOTHING TO DO".equals(exception.getMessage())) {
                    Logger.printException(exception);
                    this.setResult(1);
                    this.addMessage(exception.getMessage());
                }
            }
            finally {
                this.setFinished(true);
            }
        }
    }

    public File getResultfile() {
        return this.classTemp.getCompleteFile();
    }

    private void writeHeaderComment() {
        CommentTemplate commentTemplate = this.classTemp.createComment();
        commentTemplate.addText("$1.01$");
        commentTemplate.addText("Class " + this.m_name);
        commentTemplate.addText("Generated from " + this.m_tableModel.getType().toLowerCase() + ": " + this.m_tableModel.getName());
        commentTemplate.addText("Schema: " + this.m_tableModel.getSchema());
        commentTemplate.addText("Database: ");
        commentTemplate.addText(" ");
        commentTemplate.addText("@since: " + new Date().toString());
    }

    private void writeConstructor() {
        MethodTemplate methodTemplate = this.classTemp.createConstructor((String[][])new String[][]{{"Connection", "Object"}, {"con", "o"}});
        methodTemplate.addText("super(con,o); ");
    }

    private void writeGetObject() {
        String string = this.m_objName;
        String string2 = this.m_instance;
        MethodTemplate methodTemplate = this.classTemp.createMethod(4, "getObject", "Object", (String[][])new String[][]{{"ResultSet"}, {"rs"}});
        methodTemplate.addException("SQLException");
        methodTemplate.addText(string + " " + string2 + " = new " + string + "(");
        for (int i = 0; i < this.m_tableModel.getColumns().size(); ++i) {
            ColumnModel columnModel = (ColumnModel)this.m_tableModel.getColumns().get(i);
            if (columnModel.getName().equals("ROWID")) {
                methodTemplate.addText("\trs.getString(" + (i + 1) + ")" + (i == this.m_tableModel.getColumns().size() - 1 ? ");" : ","));
                continue;
            }
            if (columnModel.getDataType() == 2005) {
                this.classTemp.addImport("org.brains2b.data.sql.lob.LobHelper");
                methodTemplate.addText("\tLobHelper.createClob(rs.getClob(" + (i + 1) + "))" + (i == this.m_tableModel.getColumns().size() - 1 ? ");" : ","));
                continue;
            }
            if (columnModel.getDataType() == 2004) {
                this.classTemp.addImport("org.brains2b.data.sql.lob.LobHelper");
                methodTemplate.addText("\tLobHelper.createBlob(rs.getBlob(" + (i + 1) + "))" + (i == this.m_tableModel.getColumns().size() - 1 ? ");" : ","));
                continue;
            }
            if (columnModel.getDataType() == -4 || columnModel.getDataType() == -1) {
                this.classTemp.addImport("org.brains2b.data.sql.lob.LobHelper");
                methodTemplate.addText("\tLobHelper.createStream(rs.getBinaryStream(" + (i + 1) + ")," + "Oracle".equalsIgnoreCase(this.getDatabase()) + ")" + (i == this.m_tableModel.getColumns().size() - 1 ? ");" : ","));
                continue;
            }
            methodTemplate.addText("\trs.get" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModel.getDataType(), columnModel.getColumnSize(), columnModel.getDecimalDigits()), ' ') + "(" + columnModel.getSequence() + ")" + (i == this.m_tableModel.getColumns().size() - 1 ? ");" : ","));
        }
        if (this.isOptimisticLock()) {
            methodTemplate.addText(string2 + ".setChecksum(" + string2 + ".hashCode());");
        }
        methodTemplate.addText("return " + string2 + ";");
    }

    private void writeGetLargeObject() {
        String string = this.m_objName;
        String string2 = this.m_instance;
        MethodTemplate methodTemplate = this.classTemp.createMethod(4, "getObject", "Object", (String[][])new String[][]{{"ResultSet"}, {"rs"}});
        methodTemplate.addException("SQLException");
        methodTemplate.addText(string + " " + string2 + " = new " + string + "();");
        for (int i = 0; i < this.m_tableModel.getColumns().size(); ++i) {
            ColumnModel columnModel = (ColumnModel)this.m_tableModel.getColumns().get(i);
            if (columnModel.getName().equals("ROWID")) {
                methodTemplate.addText("\t" + string2 + ".set" + JavaHelper.objectName(columnModel.getName()) + "(rs.getString(" + (i + 1) + "));");
                continue;
            }
            methodTemplate.addText("\t" + string2 + ".set" + JavaHelper.objectName(this.getUnreserverdWord(columnModel.getName())) + "(rs.get" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModel.getDataType(), columnModel.getColumnSize(), columnModel.getDecimalDigits()), ' ') + "(" + columnModel.getSequence() + "));");
        }
        if (this.isOptimisticLock()) {
            methodTemplate.addText(string2 + ".setChecksum(" + string2 + ".hashCode());");
        }
        methodTemplate.addText("return " + string2 + ";");
    }

    private void writeUpdateforReadOnly() {
        MethodTemplate methodTemplate = this.classTemp.createMethod("update", "int", null);
        methodTemplate.addException("DataException");
        this.writeReadOnlyException((ContentTemplate)methodTemplate);
    }

    private void writeInsertforReadOnly() {
        MethodTemplate methodTemplate = this.classTemp.createMethod("insert", "int", null);
        methodTemplate.addException("DataException");
        this.writeReadOnlyException((ContentTemplate)methodTemplate);
    }

    private void writeDeleteforReadOnly() {
        MethodTemplate methodTemplate = this.classTemp.createMethod("delete", "int", null);
        methodTemplate.addException("DataException");
        this.writeReadOnlyException((ContentTemplate)methodTemplate);
    }

    private void writeRetrieveNonPk() {
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "retrieve", "Object", (String[])null);
        methodTemplate.addException("DataException");
        methodTemplate.addText("throw new DataException(\"Function is not available, This table has no primary key\");");
    }

    private void writeReadOnlyException(ContentTemplate contentTemplate) {
        contentTemplate.addText("throw new DataException(\"Function is not available, This table is read only\");");
    }

    private void writeUpdate() {
        int n;
        int n2;
        StringBuffer stringBuffer;
        ColumnModel[] columnModelArray = this.getPrimaryKey(this.m_tableModel);
        if (columnModelArray == null) {
            throw new RuntimeException("Table model has no primary key, pseudo primary key or ROWID. It is not possible to generate the DataControl");
        }
        MethodTemplate methodTemplate = this.classTemp.createMethod("update", "int", null);
        methodTemplate.addException("DataException");
        TryTemplate tryTemplate = methodTemplate.createTry("SQLException");
        tryTemplate.addText(this.m_objName + " " + this.m_instance + " = (" + this.m_objName + ") m_obj;");
        if (this.isOptimisticLock()) {
            tryTemplate.addText("if (" + this.m_instance + ".getChecksum()== " + this.m_instance + ".serialID())  return insert();");
            tryTemplate.addText(this.m_objName + " old = (" + this.m_objName + ") retrieve();");
            stringBuffer = tryTemplate.createIf(" old.hashCode()!=" + this.m_instance + ".getChecksum()");
            stringBuffer.addText("throw new DataException(DataException.RECORD_CHANGED);");
        }
        stringBuffer = new StringBuffer();
        stringBuffer.append("m_prep=m_con.prepareStatement(");
        stringBuffer.append("\"UPDATE ").append(this.m_tableModel.getName()).append(" SET ");
        boolean bl = true;
        for (n2 = 0; n2 < this.m_tableModel.getColumns().size(); ++n2) {
            ColumnModel columnModel = (ColumnModel)this.m_tableModel.getColumns().get(n2);
            if (this.isPrimaryKey(columnModel, this.m_tableModel)) continue;
            if (!bl) {
                stringBuffer.append(",");
            }
            stringBuffer.append(columnModel.getName() + "=?");
            bl = false;
        }
        stringBuffer.append(" WHERE ");
        for (n2 = 0; n2 < columnModelArray.length; ++n2) {
            if (n2 != 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(columnModelArray[n2].getName() + "= ? ");
        }
        stringBuffer.append("\");");
        tryTemplate.addText(stringBuffer.toString());
        n2 = 0;
        for (n = 0; n < this.m_tableModel.getColumns().size(); ++n) {
            IfTemplate ifTemplate;
            ColumnModel columnModel = (ColumnModel)this.m_tableModel.getColumns().get(n);
            String string = this.getUnreserverdWord(columnModel.getName());
            if (this.isPrimaryKey(columnModel, this.m_tableModel)) continue;
            ++n2;
            if (columnModel.getDataType() == 2005) {
                ifTemplate = tryTemplate.createIf(this.getInstance() + ".get" + JavaHelper.objectName(string) + "() != null");
                ifTemplate.addText("m_prep.setCharacterStream(" + n2 + "," + this.getInstance() + ".get" + JavaHelper.objectName(string) + "().getCharacterStream()" + ",0);");
                tryTemplate.addImport("java.sql.Types");
                ifTemplate.createElse().addText("m_prep.setNull(" + n2 + ",Types.CLOB);");
                continue;
            }
            if (columnModel.getDataType() == 2004) {
                ifTemplate = tryTemplate.createIf(this.getInstance() + ".get" + JavaHelper.objectName(string) + "() != null");
                ifTemplate.addText("m_prep.setBinaryStream(" + n2 + "," + this.getInstance() + ".get" + JavaHelper.objectName(string) + "().getBinaryStream()" + ",0);");
                tryTemplate.addImport("java.sql.Types");
                ifTemplate.createElse().addText("m_prep.setNull(" + n2 + ",Types.BLOB);");
                continue;
            }
            if (columnModel.getDataType() == -4 || columnModel.getDataType() == -1) {
                ifTemplate = tryTemplate.createIf(this.getInstance() + ".get" + JavaHelper.objectName(string) + "() != null");
                ifTemplate.addText("m_prep.setBinaryStream(" + n2 + "," + this.getInstance() + ".get" + JavaHelper.objectName(string) + "().getInputStream()" + ",0);");
                ifTemplate.createElse().addText("m_prep.setNull(" + n2 + "," + columnModel.getDataType() + ");");
                continue;
            }
            tryTemplate.addText("m_prep.set" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModel.getDataType(), columnModel.getColumnSize(), columnModel.getDecimalDigits()), ' ') + "(" + n2 + "," + this.m_instance + ".get" + JavaHelper.objectName(string) + "());");
        }
        if (!columnModelArray[0].getName().equals("ROWID")) {
            for (n = 0; n < columnModelArray.length; ++n) {
                ++n2;
                if ("Oracle".equalsIgnoreCase(this.getDatabase()) && columnModelArray[n].getDataType() == 1 && columnModelArray[n].getColumnSize() > 1) {
                    tryTemplate.addText("m_prep.setObject(" + n2 + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[n].getName())) + "(), OracleTypes.FIXED_CHAR);");
                    tryTemplate.addImport("oracle.jdbc.driver.OracleTypes");
                    continue;
                }
                tryTemplate.addText("m_prep.set" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModelArray[n].getDataType(), columnModelArray[n].getColumnSize(), columnModelArray[n].getDecimalDigits()), ' ') + "(" + n2 + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[n].getName())) + "());");
            }
        } else {
            tryTemplate.addText("m_prep.setString(" + ++n2 + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[0].getName())) + "());");
        }
        tryTemplate.addText("");
        tryTemplate.addText("int result=m_prep.executeUpdate();");
        if (this.isOptimisticLock()) {
            tryTemplate.addText(this.m_instance + ".setChecksum(old.hashCode());");
        }
        tryTemplate.addText("return result;");
        ExceptionTemplate exceptionTemplate = tryTemplate.getDefaultException();
        exceptionTemplate.addText("throw new DataException(DataException.UPDATE_FAILED,sqlex);");
        tryTemplate.createFinally().createTry("SQLException").addText("if (m_prep!=null) m_prep.close();");
    }

    protected void writeInsert() {
        ColumnModel columnModel;
        int n;
        MethodTemplate methodTemplate = this.classTemp.createMethod("insert", "int", null);
        methodTemplate.addException("DataException");
        TryTemplate tryTemplate = methodTemplate.createTry("SQLException");
        tryTemplate.addText(this.m_objName + " " + this.m_instance + " = (" + this.m_objName + ") m_obj;");
        ColumnModel[] columnModelArray = this.getPrimaryKey(this.m_tableModel);
        StringBuffer stringBuffer = new StringBuffer();
        if (columnModelArray != null && columnModelArray.length > 0 && !columnModelArray[0].getName().equals("ROWID")) {
            for (int i = 0; i < columnModelArray.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(" && ");
                }
                stringBuffer.append(this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[i].getName())) + "() ==" + this.getEmptyForType(columnModelArray[i].getDataType()));
            }
            tryTemplate.createIf(stringBuffer.toString()).addText("throw new DataException(DataException.NO_PRIMARY_KEY);");
        }
        tryTemplate.addText("m_prep=m_con.prepareStatement(");
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer2.append("\"INSERT INTO ").append(this.m_tableModel.getName()).append(" (");
        for (n = 0; n < this.m_tableModel.getColumns().size(); ++n) {
            columnModel = (ColumnModel)this.m_tableModel.getColumns().get(n);
            if (columnModel.getName().equals("ROWID")) continue;
            if (n != 0) {
                stringBuffer2.append(",");
                stringBuffer3.append(",");
            }
            stringBuffer2.append(columnModel.getName());
            stringBuffer3.append("?");
        }
        stringBuffer2.append(")");
        stringBuffer3.append(")");
        stringBuffer2.append(" VALUES ( ").append(stringBuffer3.toString());
        stringBuffer2.append("\");");
        tryTemplate.addText(stringBuffer2.toString());
        for (n = 0; n < this.m_tableModel.getColumns().size(); ++n) {
            IfTemplate ifTemplate;
            columnModel = (ColumnModel)this.m_tableModel.getColumns().get(n);
            String string = this.getUnreserverdWord(columnModel.getName());
            if (columnModel.getDataType() == 2005) {
                ifTemplate = tryTemplate.createIf(this.getInstance() + ".get" + JavaHelper.objectName(string) + "() != null");
                ifTemplate.addText("m_prep.setCharacterStream(" + columnModel.getSequence() + "," + this.getInstance() + ".get" + JavaHelper.objectName(string) + "().getCharacterStream()" + ",0);");
                tryTemplate.addImport("java.sql.Types");
                ifTemplate.createElse().addText("m_prep.setNull(" + columnModel.getSequence() + ",Types.CLOB);");
                continue;
            }
            if (columnModel.getDataType() == 2004) {
                ifTemplate = tryTemplate.createIf(this.getInstance() + ".get" + JavaHelper.objectName(string) + "() != null");
                ifTemplate.addText("m_prep.setBinaryStream(" + columnModel.getSequence() + "," + this.getInstance() + ".get" + JavaHelper.objectName(string) + "().getBinaryStream()" + ",0);");
                tryTemplate.addImport("java.sql.Types");
                ifTemplate.createElse().addText("m_prep.setNull(" + columnModel.getSequence() + ",Types.BLOB);");
                continue;
            }
            if (columnModel.getDataType() == -4 || columnModel.getDataType() == -1) {
                ifTemplate = tryTemplate.createIf(this.getInstance() + ".get" + JavaHelper.objectName(string) + "() != null");
                ifTemplate.addText("m_prep.setBinaryStream(" + columnModel.getSequence() + "," + this.getInstance() + ".get" + JavaHelper.objectName(string) + "().getInputStream()" + ",0);");
                ifTemplate.createElse().addText("m_prep.setNull(" + columnModel.getSequence() + "," + columnModel.getDataType() + ");");
                continue;
            }
            if (columnModel.getName().equals("ROWID")) continue;
            tryTemplate.addText("m_prep.set" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModel.getDataType(), columnModel.getColumnSize(), columnModel.getDecimalDigits()), ' ') + "(" + columnModel.getSequence() + "," + this.m_instance + ".get" + JavaHelper.objectName(string) + "());");
        }
        tryTemplate.addText("");
        tryTemplate.addText("int result=m_prep.executeUpdate();");
        if (this.isOptimisticLock()) {
            tryTemplate.addText(this.m_instance + ".setChecksum(" + this.m_instance + ".hashCode());");
        }
        tryTemplate.addText("return result;");
        ExceptionTemplate exceptionTemplate = tryTemplate.getDefaultException();
        exceptionTemplate.addText("throw new DataException(DataException.UPDATE_FAILED,sqlex);");
        tryTemplate.createFinally().createTry("SQLException").addText("if (m_prep!=null) m_prep.close();");
    }

    private void writeDelete() {
        int n;
        ColumnModel[] columnModelArray = this.getPrimaryKey(this.m_tableModel);
        if (columnModelArray == null) {
            throw new RuntimeException("Table model has no primary key, pseudo primary key or ROWID. It is not possible to generate the DataControl");
        }
        MethodTemplate methodTemplate = this.classTemp.createMethod("delete", "int", null);
        methodTemplate.addException("DataException");
        TryTemplate tryTemplate = methodTemplate.createTry("SQLException");
        tryTemplate.addText(this.m_objName + " " + this.m_instance + " = (" + this.m_objName + ") m_obj;");
        tryTemplate.addText("m_prep=m_con.prepareStatement(");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"DELETE FROM ").append(this.m_tableModel.getName());
        stringBuffer.append(" WHERE ");
        for (n = 0; n < columnModelArray.length; ++n) {
            if (n != 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(columnModelArray[n].getName() + "= ? ");
        }
        stringBuffer.append("\");");
        tryTemplate.addText(stringBuffer.toString());
        n = 0;
        for (int i = 0; i < columnModelArray.length; ++i) {
            ++n;
            if ("Oracle".equalsIgnoreCase(this.getDatabase()) && columnModelArray[i].getDataType() == 1 && columnModelArray[i].getColumnSize() > 1) {
                tryTemplate.addText("m_prep.setObject(" + n + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[i].getName())) + "(), OracleTypes.FIXED_CHAR);");
                tryTemplate.addImport("oracle.jdbc.driver.OracleTypes");
                continue;
            }
            tryTemplate.addText("\t\t m_prep.set" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModelArray[i].getDataType(), columnModelArray[i].getColumnSize(), columnModelArray[i].getDecimalDigits()), ' ') + "(" + n + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[i].getName())) + "());");
        }
        tryTemplate.addText("");
        tryTemplate.addText("int result=m_prep.executeUpdate();");
        tryTemplate.addText("return result;");
        ExceptionTemplate exceptionTemplate = tryTemplate.getDefaultException();
        exceptionTemplate.addText("throw new DataException(DataException.DELETE_FAILED,sqlex);");
        tryTemplate.createFinally().createTry("SQLException").addText("m_prep.close();");
    }

    private void writeRetrieve() {
        int n;
        ColumnModel[] columnModelArray = this.getPrimaryKey(this.m_tableModel);
        if (columnModelArray == null) {
            throw new RuntimeException("Table model has no primary key, pseudo primary key or ROWID. It is not possible to generate the DataControl");
        }
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "retrieve", "Object", (String[])null);
        methodTemplate.addException("DataException");
        TryTemplate tryTemplate = methodTemplate.createTry("SQLException");
        tryTemplate.addText(this.m_objName + " " + this.m_instance + " = (" + this.m_objName + ") m_obj;");
        tryTemplate.addText("m_prep=m_con.prepareStatement(");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"SELECT ");
        for (n = 0; n < this.m_tableModel.getColumns().size(); ++n) {
            ColumnModel columnModel = (ColumnModel)this.m_tableModel.getColumns().get(n);
            stringBuffer.append(columnModel.getName());
            if (n == this.m_tableModel.getColumns().size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM " + this.m_tableModel.getName());
        stringBuffer.append(" WHERE ");
        for (n = 0; n < columnModelArray.length; ++n) {
            if (n != 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(columnModelArray[n].getName() + "= ? ");
        }
        stringBuffer.append("\");");
        tryTemplate.addText(stringBuffer.toString());
        n = 0;
        for (int i = 0; i < columnModelArray.length; ++i) {
            ++n;
            if ("Oracle".equalsIgnoreCase(this.getDatabase()) && columnModelArray[i].getDataType() == 1 && columnModelArray[i].getColumnSize() > 1) {
                tryTemplate.addText("m_prep.setObject(" + n + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[i].getName())) + "(), OracleTypes.FIXED_CHAR);");
                tryTemplate.addImport("oracle.jdbc.driver.OracleTypes");
                continue;
            }
            tryTemplate.addText("m_prep.set" + StringHelper.initCaps(this.m_typeInfo.getJavaTypeName(columnModelArray[i].getDataType(), columnModelArray[i].getColumnSize(), columnModelArray[i].getDecimalDigits()), ' ') + "(" + n + "," + this.m_instance + ".get" + JavaHelper.objectName(this.getUnreserverdWord(columnModelArray[i].getName())) + "());");
        }
        tryTemplate.addText("");
        tryTemplate.addText("ResultSet rs=m_prep.executeQuery();");
        tryTemplate.addText("Object out=null;");
        IfTemplate ifTemplate = tryTemplate.createIf("rs.next()");
        ifTemplate.addText("out= getObject(rs);");
        tryTemplate.addText("return out;");
        ExceptionTemplate exceptionTemplate = tryTemplate.getDefaultException();
        exceptionTemplate.addText("throw new DataException(DataException.UPDATE_FAILED,sqlex);");
        tryTemplate.createFinally().createTry("SQLException").addText("m_prep.close();");
    }

    private void writeRetrieveList() {
        this.classTemp.addImport("org.brains2b.data.Condition");
        this.classTemp.addImport("org.brains2b.data.sql.SqlCondition");
        MethodTemplate methodTemplate = this.classTemp.createMethod(1, "retrieveList", "List", (String[][])new String[][]{{"Condition"}, {"con"}});
        methodTemplate.addException("DataException");
        TryTemplate tryTemplate = methodTemplate.createTry("SQLException");
        tryTemplate.addImport("java.util.ArrayList");
        tryTemplate.addText("List v=new ArrayList();");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("String select= \"SELECT ");
        for (int i = 0; i < this.m_tableModel.getColumns().size(); ++i) {
            ColumnModel columnModel = (ColumnModel)this.m_tableModel.getColumns().get(i);
            stringBuffer.append(columnModel.getName());
            if (i == this.m_tableModel.getColumns().size() - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM ").append(this.m_tableModel.getName()).append("\";");
        tryTemplate.addText(stringBuffer.toString());
        tryTemplate.addText("m_prep=((SqlCondition) con).getPreparedStatement(m_con,select);");
        tryTemplate.addText("");
        tryTemplate.addText("ResultSet rs=m_prep.executeQuery();");
        tryTemplate.createWhile("rs.next()").addText("v.add(getObject(rs));");
        tryTemplate.createIf("v.isEmpty()").addText("return null;");
        tryTemplate.addText("return v;");
        ExceptionTemplate exceptionTemplate = tryTemplate.getDefaultException();
        exceptionTemplate.addText("throw new DataException(DataException.RETRIEVE_FAILED,sqlex);");
        tryTemplate.createFinally().createTry("SQLException").addText("m_prep.close();");
    }

    protected ColumnModel[] getPrimaryKey(TableModel tableModel) {
        if (tableModel.getPrimaryKey() == null) {
            return null;
        }
        ColumnModel[] columnModelArray = new ColumnModel[tableModel.getPrimaryKey().getColumns().size()];
        tableModel.getPrimaryKey().getColumns().toArray(columnModelArray);
        for (int i = 0; i < columnModelArray.length; ++i) {
            Iterator iterator = tableModel.getColumns().iterator();
            while (iterator.hasNext()) {
                ColumnModel columnModel = (ColumnModel)iterator.next();
                if (!columnModelArray[i].getName().equals(columnModel.getName())) continue;
                columnModelArray[i] = columnModel;
            }
        }
        return columnModelArray;
    }

    protected String getEmptyForType(int n) {
        return this.m_typeInfo.isPrimitive(n) ? "0" : "null";
    }

    protected String getClassName(String string) {
        string = this.getUnreserverdWord(string);
        this.m_objName = JavaHelper.objectName(string);
        return this.m_objName + "DC";
    }

    protected boolean isReadOnly() {
        return this.m_readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.m_readOnly = bl;
    }

    protected boolean isOptimisticLock() {
        return this.m_optimisticLock;
    }

    public void setOptimisticLock(boolean bl) {
        this.m_optimisticLock = bl;
    }

    public String getDatabase() {
        return this.m_database;
    }

    public void setDatabase(String string) {
        this.m_database = string;
    }

    protected ClassTemplate getClassTemp() {
        return this.classTemp;
    }

    protected String getInstance() {
        return this.m_instance;
    }

    protected String getObjectName() {
        return this.m_objName;
    }
}

