/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.sql.toclass;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import org.brains2b.console.ArgumentException;
import org.brains2b.console.ArgumentMap;
import org.brains2b.console.Main;
import org.brains2b.data.DataException;
import org.brains2b.log.Logger;
import org.brains2b.sql.Connector;
import org.brains2b.sql.LocalConnector;
import org.brains2b.sql.meta.SQLMetaData;
import org.brains2b.sql.meta.TableModel;
import org.brains2b.sql.toclass.Sql2DataC;
import org.brains2b.sql.toclass.Sql2File;

public class Sql2ClassConsole
extends Main {
    public static final String VERSIONID = "$1.01$";
    private static final String PROPERTIES = "sql2class.properties";

    public Sql2ClassConsole() {
        this.init();
    }

    public static void main(String[] stringArray) {
        try {
            Sql2ClassConsole sql2ClassConsole = new Sql2ClassConsole();
            sql2ClassConsole.initialize(stringArray);
            sql2ClassConsole.makeClass();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Sql2ClassConsole.printHelp();
        }
    }

    private void init() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.addOption("table", 't', true);
        argumentMap.addArgumentTo("table", "tablename", true);
        argumentMap.addOption("driver", 'd', true);
        argumentMap.addArgumentTo("driver", "name", true);
        argumentMap.addOption("url", 'r', true);
        argumentMap.addArgumentTo("url", "name", true);
        argumentMap.addOption("user", 'u', false);
        argumentMap.addArgumentTo("user", "name", true);
        argumentMap.addOption("password", 'p', false);
        argumentMap.addArgumentTo("password", "word", true);
        argumentMap.addOption("catalog", 'c', false);
        argumentMap.addArgumentTo("catalog", "name", true);
        argumentMap.addOption("location", 'l', false);
        argumentMap.addArgumentTo("location", "dir", true);
        argumentMap.addOption("package", 'g', false);
        argumentMap.addArgumentTo("package", "name", true);
        argumentMap.addOption("readonly", 'w', false);
        argumentMap.addOption("forcerowid", 'f', false);
        argumentMap.addOption("optimistic", 'o', false);
        argumentMap.addOption("trim", 'o', false);
        argumentMap.addOption("default", 'i', false);
        argumentMap.addOption("force", '0', false);
        argumentMap.addOption("model", '0', false);
        argumentMap.addArgumentTo("model", "type", true);
        this.setArgumentMap(argumentMap);
    }

    protected void initialize(Properties properties) throws ArgumentException {
        String[] stringArray = new String[properties.size() * 2];
        int n = 0;
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringArray[n++] = "--" + string;
            stringArray[n++] = properties.getProperty(string);
        }
        this.makeArgumentList(stringArray);
    }

    private void initialize(String[] stringArray) throws Exception {
        Properties properties = this.readProperties();
        String[] stringArray2 = new String[stringArray.length + properties.size() * 2];
        int n = 0;
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringArray2[n++] = "--" + string;
            stringArray2[n++] = properties.getProperty(string);
        }
        System.arraycopy(stringArray, 0, stringArray2, properties.size() * 2, stringArray.length);
        this.makeArgumentList(stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeClass() throws SQLException, DataException {
        Object object;
        this.setArgument("user", this.getArgument("user").toUpperCase());
        File file = null;
        if (this.getArgument("location") != null) {
            file = new File(this.getArgument("location"));
        }
        Sql2File sql2File = new Sql2File(file, this.getArgument("package"));
        Sql2DataC sql2DataC = new Sql2DataC(file, this.getArgument("package"));
        boolean bl = false;
        boolean bl2 = false;
        if (this.getArgument("force") == null) {
            bl = sql2File.fileExists(this.getArgument("table"));
            bl2 = sql2DataC.fileExists(this.getArgument("table"));
            if (bl && bl2) {
                return;
            }
        }
        Connector connector = null;
        SQLMetaData sQLMetaData = null;
        TableModel tableModel = null;
        try {
            connector = new LocalConnector(this.getArgument("driver"), this.getArgument("url"), this.getArgument("user"), this.getArgument("password"));
            sQLMetaData = new SQLMetaData(connector.getConnection());
            sQLMetaData.getTypeInfo().setDataModel(this.getModel());
            Logger.println("finding Table: " + this.getArgument("table"), 16);
            object = sQLMetaData.getTables(this.getArgument("catalog"), this.getArgument("user"), this.getArgument("table"));
            if (object.size() != 1) {
                throw new DataException("No table found, or more then one with name " + this.getArgument("table"));
            }
            tableModel = (TableModel)object.get(0);
            Logger.println("finding Columns: " + this.getArgument("table"), 16);
            sQLMetaData.setColumns(tableModel);
            Logger.println("finding PrimaryKeys: " + this.getArgument("table"), 16);
            sQLMetaData.setPrimaryKey(tableModel, "true".equals(this.getArgument("forcerowid")));
        }
        finally {
            connector.close();
        }
        if (!bl) {
            sql2File.setTypeInfo(sQLMetaData.getTypeInfo());
            sql2File.setTableModel(tableModel);
            sql2File.setTrimValue("true".equals(this.getArgument("trim")));
            sql2File.setDefault("true".equals(this.getArgument("default")));
            sql2File.setOptimisticLock("true".equals(this.getArgument("optimistic")));
            object = new Thread(sql2File);
            ((Thread)object).run();
        }
        if (!bl2) {
            sql2DataC.setTypeInfo(sQLMetaData.getTypeInfo());
            sql2DataC.setTableModel(tableModel);
            sql2DataC.setReadOnly("true".equals(this.getArgument("readonly")));
            sql2DataC.setDatabase(sQLMetaData.getMetaData().getDatabaseProductName());
            object = new Thread(sql2DataC);
            ((Thread)object).run();
        }
    }

    private Properties readProperties() throws Exception {
        Properties properties = new Properties();
        try {
            File file = new File(PROPERTIES);
            properties.load(new FileInputStream(file));
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return properties;
    }

    private int getModel() {
        if ("small".equals(this.getArgument("model"))) {
            return 22;
        }
        if ("large".equals(this.getArgument("model"))) {
            return 9;
        }
        return 10;
    }

    private static final void printHelp() {
    }
}

