/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.sql.lob;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class LobCache
implements Blob {
    static final int SIZE = 4096;
    private ByteBuffer m_buf = ByteBuffer.allocateDirect(4096);
    private File m_cache;
    private int m_hashCode = 13;
    private int m_size;

    public InputStream getBinaryStream() throws SQLException {
        try {
            if (this.m_cache != null) {
                return new FileInputStream(this.m_cache);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SQLException("Cache file " + this.m_cache.getAbsolutePath() + " cannot be found");
        }
        return new InputStream(){

            public int read() throws IOException {
                if (this.available() > 0) {
                    return LobCache.this.m_buf.get();
                }
                return -1;
            }

            public synchronized void reset() throws IOException {
                LobCache.this.m_buf.reset();
            }

            public int available() throws IOException {
                return LobCache.this.m_size - LobCache.this.m_buf.position();
            }
        };
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.m_cache != null) {
            try {
                return this.readCache(l, n);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        byte[] byArray = new byte[n];
        this.m_buf.get(byArray, 0, n);
        return byArray;
    }

    public long length() throws SQLException {
        if (this.m_cache != null) {
            return this.m_cache.length();
        }
        return this.m_size;
    }

    public long position(Blob blob, long l) throws SQLException {
        throw new SQLException("LobCache only supports position(byte[],start)");
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (this.m_cache != null) {
            try {
                return this.findInCache(byArray, l);
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        byte[] byArray2 = new byte[this.m_size];
        this.m_buf.get(byArray2);
        return this.find(byArray2, this.m_size, byArray, l);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.truncate(l);
        return new OutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(int n) throws IOException {
                LobCache.this.m_buf.put((byte)n);
                if (LobCache.this.m_buf.remaining() < 1) {
                    ByteBuffer byteBuffer = LobCache.this.m_buf;
                    synchronized (byteBuffer) {
                        LobCache.this.writeCache();
                        LobCache.this.m_buf.notify();
                    }
                }
            }

            public void flush() throws IOException {
                if (LobCache.this.m_cache != null) {
                    LobCache.this.writeCache();
                } else {
                    LobCache.this.m_size = LobCache.this.m_buf.position();
                    LobCache.this.m_buf.position(0);
                }
            }

            public void close() throws IOException {
                this.flush();
            }
        };
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        try {
            OutputStream outputStream = this.setBinaryStream(l);
            outputStream.write(byArray, n, n2);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
        return n2;
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public void truncate(long l) throws SQLException {
        if (this.m_cache != null && l > this.m_cache.length() + (long)this.m_buf.capacity()) {
            throw new SQLException("Cannot write beyond current location of buffer");
        }
        if (this.m_cache != null && l < this.m_cache.length()) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.m_cache, "rw");
                randomAccessFile.setLength(l);
            }
            catch (IOException iOException) {
                throw new SQLException("Cannot set new starting point for OutputStream");
            }
        } else if (this.m_cache == null && l < (long)this.m_buf.position()) {
            this.m_buf.position((int)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findInCache(byte[] byArray, long l) throws IOException {
        long l2 = 0L;
        FileInputStream fileInputStream = new FileInputStream(this.m_cache);
        try {
            fileInputStream.skip(l);
            l2 = l;
            byte[] byArray2 = new byte[4096];
            int n = 0;
            while ((n = fileInputStream.read(byArray2)) != -1) {
                long l3 = this.find(byArray2, n, byArray, 0L);
                if (l3 != -1L) {
                    long l4 = l2 + l3;
                    return l4;
                }
                l2 += 4096L;
            }
        }
        finally {
            fileInputStream.close();
        }
        return -1L;
    }

    private long find(byte[] byArray, int n, byte[] byArray2, long l) {
        long l2 = -1L;
        int n2 = 0;
        for (int i = (int)l; i < n; ++i) {
            if (byArray[i] == byArray2[n2++]) {
                if (n2 == 1) {
                    l2 = i;
                }
                if (n2 < byArray2.length) continue;
                return l2;
            }
            n2 = 0;
        }
        return -1L;
    }

    private byte[] readCache(long l, int n) throws IOException {
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = new FileInputStream(this.m_cache);
        fileInputStream.skip(l);
        fileInputStream.read(byArray);
        return byArray;
    }

    private void writeCache() throws IOException {
        if (this.m_cache == null) {
            this.m_cache = File.createTempFile("lob", ".tmp");
            this.m_cache.deleteOnExit();
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.m_cache, "rw");
        randomAccessFile.seek(randomAccessFile.length());
        byte[] byArray = new byte[this.m_buf.position()];
        this.m_buf.position(0);
        this.m_buf.get(byArray);
        this.m_hashCode += Arrays.hashCode(byArray);
        randomAccessFile.write(byArray, 0, byArray.length);
        randomAccessFile.close();
        this.m_buf.clear();
    }

    protected void finalize() throws Throwable {
        if (this.m_cache != null && this.m_cache.exists()) {
            this.m_cache.delete();
        }
        super.finalize();
    }

    public int hashCode() {
        if (this.m_cache != null) {
            return this.m_hashCode;
        }
        return this.m_buf.hashCode();
    }
}

