/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.sql.lob;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.brains2b.data.sql.lob.LobCache;
import org.brains2b.sql.meta.types.Stream;

public class DisconnectedStream
implements Stream {
    private LobCache m_cache = new LobCache();

    public DisconnectedStream() {
    }

    public DisconnectedStream(InputStream inputStream) {
        this.cacheStream(inputStream);
    }

    public InputStream getInputStream() throws SQLException {
        return this.m_cache.getBinaryStream();
    }

    public OutputStream getOutputStream() throws SQLException {
        return this.m_cache.setBinaryStream(0L);
    }

    public boolean isAccessed() throws SQLException {
        return true;
    }

    void cacheStream(InputStream inputStream) {
        try {
            byte[] byArray = new byte[4096];
            int n = 0;
            OutputStream outputStream = this.m_cache.setBinaryStream(0L);
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int hashCode() {
        return this.m_cache != null ? this.m_cache.hashCode() : 13;
    }
}

