/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.sql.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.brains2b.data.sql.lob.LobCache;
import org.brains2b.sql.meta.types.Stream;

public class ConnectedStream
implements Stream {
    private LobCache m_cache;
    private InputStream m_is;

    public ConnectedStream() {
        this.m_cache = new LobCache();
    }

    public ConnectedStream(InputStream inputStream) {
        this.m_is = inputStream;
    }

    public InputStream getInputStream() throws SQLException {
        if (this.m_cache != null) {
            return this.m_cache.getBinaryStream();
        }
        if (this.m_cache == null) {
            this.m_cache = new LobCache();
        }
        final OutputStream outputStream = this.m_cache.setBinaryStream(0L);
        return new InputStream(){

            public int read() throws IOException {
                int n = ConnectedStream.this.m_is.read();
                outputStream.write(n);
                return n;
            }

            public void close() throws IOException {
                outputStream.close();
            }
        };
    }

    public OutputStream getOutputStream() throws SQLException {
        if (this.m_cache == null) {
            this.m_cache = new LobCache();
        }
        return this.m_cache.setBinaryStream(0L);
    }

    public boolean isAccessed() throws SQLException {
        return this.m_cache != null && this.m_cache.length() > 0L;
    }

    public int hashCode() {
        return this.m_cache != null ? this.m_cache.hashCode() : 13;
    }
}

