/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.sql.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.brains2b.data.sql.lob.LobCache;

public class ClobImpl
implements Clob {
    private Clob m_clob;
    private LobCache m_internal;

    public ClobImpl() {
        this.m_internal = new LobCache();
    }

    public ClobImpl(Clob clob) {
        this.m_clob = clob;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.m_clob != null) {
            return this.m_clob.getAsciiStream();
        }
        return this.m_internal.getBinaryStream();
    }

    public Reader getCharacterStream() throws SQLException {
        return new InputStreamReader(this.getAsciiStream());
    }

    public String getSubString(long l, int n) throws SQLException {
        if (this.m_clob != null) {
            return this.m_clob.getSubString(l, n);
        }
        return new String(this.m_internal.getBytes(l, n));
    }

    public long length() throws SQLException {
        if (this.m_clob != null) {
            return this.m_clob.length();
        }
        return this.m_internal.length();
    }

    public long position(String string, long l) throws SQLException {
        if (this.m_clob != null) {
            return this.m_clob.position(string, l);
        }
        return this.m_internal.position(string.getBytes(), l * 2L);
    }

    public long position(Clob clob, long l) throws SQLException {
        if (this.m_clob != null) {
            return this.m_clob.position(clob, l);
        }
        return this.m_internal.position(clob.getSubString(0L, (int)clob.length()).getBytes(), l * 2L);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        return new OutputStreamWriter(this.setAsciiStream(l));
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.m_clob != null) {
            try {
                return this.m_clob.setAsciiStream(l);
            }
            catch (SQLException sQLException) {
                return this.getInternalStream(l);
            }
        }
        return this.m_internal.setBinaryStream(l * 2L);
    }

    public int setString(long l, String string) throws SQLException {
        if (this.m_clob != null) {
            try {
                return this.m_clob.setString(l, string);
            }
            catch (SQLException sQLException) {
                return this.setInternalString(l, string, 0, (int)this.m_clob.length());
            }
        }
        return this.m_internal.setBytes(l, string.getBytes(), 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (this.m_clob != null) {
            try {
                return this.m_clob.setString(l, string, n, n2);
            }
            catch (SQLException sQLException) {
                return this.setInternalString(l, string, n, n2);
            }
        }
        return this.m_internal.setBytes(l, string.substring(n, n2).getBytes());
    }

    public void truncate(long l) throws SQLException {
        if (this.m_clob != null) {
            if (l < 0L || l > this.m_clob.length()) {
                return;
            }
            try {
                this.m_clob.truncate(l);
            }
            catch (SQLException sQLException) {
                this.setInternalString(0L, this.getSubString(0L, (int)l), 0, (int)this.m_clob.length());
            }
        }
        if (l < 0L || l > this.m_internal.length()) {
            return;
        }
        this.m_internal.setBytes(0L, this.getSubString(0L, (int)l).getBytes(), 0, (int)l);
    }

    public int hashCode() {
        if (this.m_clob != null) {
            return 13;
        }
        return this.m_internal.hashCode();
    }

    private OutputStream getInternalStream(long l) throws SQLException {
        this.makeLobCache();
        return this.m_internal.setBinaryStream(l);
    }

    private int setInternalString(long l, String string, int n, int n2) throws SQLException {
        this.makeLobCache();
        String string2 = string.substring(n, n2);
        return this.m_internal.setBytes(l * 2L, string2.getBytes(), 0, string2.length() * 2);
    }

    private synchronized void makeLobCache() throws SQLException {
        this.m_internal = new LobCache();
        byte[] byArray = new byte[4096];
        int n = 0;
        OutputStream outputStream = this.m_internal.setBinaryStream(0L);
        InputStream inputStream = this.m_clob.getAsciiStream();
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.close();
            inputStream.close();
            this.m_clob = null;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }
}

