/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.sql.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.brains2b.data.sql.lob.LobCache;

public class BlobImpl
implements Blob {
    private Blob m_blob;
    private LobCache m_internal;

    public BlobImpl() {
        this.m_internal = new LobCache();
    }

    public BlobImpl(Blob blob) {
        this.m_blob = blob;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.m_blob != null) {
            return this.m_blob.getBinaryStream();
        }
        return this.m_internal.getBinaryStream();
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.m_blob != null) {
            return this.m_blob.getBytes(l, n);
        }
        return this.m_internal.getBytes(l, n);
    }

    public long length() throws SQLException {
        if (this.m_blob != null) {
            return this.m_blob.length();
        }
        return this.m_internal.length();
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (this.m_blob != null) {
            return this.m_blob.position(byArray, l);
        }
        return this.m_internal.position(byArray, l);
    }

    public long position(Blob blob, long l) throws SQLException {
        if (this.m_blob != null) {
            return this.m_blob.position(blob, l);
        }
        return this.m_internal.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (this.m_blob != null) {
            try {
                return this.m_blob.setBinaryStream(l);
            }
            catch (SQLException sQLException) {
                return this.getInternalStream(l);
            }
        }
        return this.m_internal.setBinaryStream(l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (this.m_blob != null) {
            try {
                return this.m_blob.setBytes(l, byArray);
            }
            catch (SQLException sQLException) {
                return this.setInternalBytes(l, byArray, 0, (int)this.m_blob.length());
            }
        }
        return this.m_internal.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (this.m_blob != null) {
            try {
                return this.m_blob.setBytes(l, byArray, n, n2);
            }
            catch (SQLException sQLException) {
                return this.setInternalBytes(l, byArray, 0, (int)this.m_blob.length());
            }
        }
        return this.m_internal.setBytes(l, byArray, 0, (int)this.m_blob.length());
    }

    public void truncate(long l) throws SQLException {
        if (this.m_blob != null) {
            try {
                this.m_blob.truncate(l);
            }
            catch (SQLException sQLException) {
                this.setInternalBytes(0L, this.getBytes(0L, (int)l), 0, (int)this.m_blob.length());
            }
        }
        this.m_internal.setBytes(0L, this.getBytes(0L, (int)l), 0, (int)this.m_blob.length());
    }

    public int hashCode() {
        if (this.m_blob != null) {
            return 13;
        }
        return this.m_internal.hashCode();
    }

    private OutputStream getInternalStream(long l) throws SQLException {
        this.makeLobCache();
        return this.m_internal.setBinaryStream(l);
    }

    private int setInternalBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.makeLobCache();
        return this.m_internal.setBytes(l, byArray, n, n2);
    }

    private synchronized void makeLobCache() throws SQLException {
        this.m_internal = new LobCache();
        byte[] byArray = new byte[4096];
        int n = 0;
        OutputStream outputStream = this.m_blob.setBinaryStream(0L);
        InputStream inputStream = this.m_blob.getBinaryStream();
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.close();
            inputStream.close();
            this.m_blob = null;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }
}

