/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.sql.cursor;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.brains2b.data.Condition;
import org.brains2b.data.DataException;
import org.brains2b.data.cursor.Cursor;
import org.brains2b.data.cursor.CursorData;
import org.brains2b.data.sql.SqlCondition;
import org.brains2b.data.sql.lob.LobHelper;
import org.brains2b.log.Logger;
import org.brains2b.sql.meta.SelectDescriptor;
import org.brains2b.sql.meta.TypesInfo;
import org.brains2b.sql.meta.types.Stream;
import org.brains2b.util.StringHelper;

public class SqlCursor
extends Cursor {
    protected SelectDescriptor m_select;
    protected PreparedStatement m_prep;
    protected Connection m_con;
    private ArrayList m_parameters;
    private TypesInfo m_typeInfo;
    private boolean m_resultClosed;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$org$brains2b$sql$meta$types$Stream;

    public SqlCursor(String string, String string2) {
        super(string);
        this.m_select = new SelectDescriptor(string2);
    }

    public SqlCursor(Connection connection, String string, String string2) {
        super(string);
        this.m_con = connection;
        this.m_select = new SelectDescriptor(string2);
    }

    public CursorData retrieve(Condition condition) throws DataException {
        List list = this.retrieveList(condition);
        if (list == null) {
            return null;
        }
        return (CursorData)list.get(0);
    }

    protected CursorData getObject(CursorData cursorData, ResultSet resultSet) throws SQLException {
        CursorData cursorData2 = (CursorData)cursorData.clone();
        cursorData2.setRowNo(resultSet.getRow());
        for (int i = 0; i < cursorData2.getColumnCount(); ++i) {
            if (cursorData2.getColumnType(i) == (class$java$sql$Blob == null ? SqlCursor.class$("java.sql.Blob") : class$java$sql$Blob)) {
                cursorData2.setValue(i, (Object)LobHelper.createBlob((Blob)resultSet.getObject(i + 1)));
                continue;
            }
            if (cursorData2.getColumnType(i) == (class$java$sql$Clob == null ? SqlCursor.class$("java.sql.Clob") : class$java$sql$Clob)) {
                cursorData2.setValue(i, (Object)LobHelper.createClob((Clob)resultSet.getObject(i + 1)));
                continue;
            }
            if (cursorData2.getColumnType(i) == (class$org$brains2b$sql$meta$types$Stream == null ? SqlCursor.class$("org.brains2b.sql.meta.types.Stream") : class$org$brains2b$sql$meta$types$Stream)) {
                cursorData2.setValue(i, (Object)LobHelper.createStream(resultSet.getBinaryStream(i + 1), this.m_resultClosed));
                continue;
            }
            cursorData2.setValue(i, resultSet.getObject(i + 1));
        }
        cursorData2.setChecksum(cursorData2.hashCode());
        return cursorData2;
    }

    public CursorData getProtoType() throws DataException {
        if (this.m_prototype != null) {
            return (CursorData)this.m_prototype.cloneAll();
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_select.getColumns()).append(this.m_select.getFrom());
            if (this.m_select.getWhere() != null) {
                stringBuffer.append(this.m_select.getWhere());
            }
            String string = this.getTypeInfo().getLimitRows(1);
            if (stringBuffer.indexOf("WHERE") != -1) {
                string = string.replaceFirst("WHERE", "AND");
            }
            stringBuffer.append(string);
            if (this.m_select.getGroupBy() != null) {
                stringBuffer.append(" ").append(this.m_select.getGroupBy());
            }
            String string2 = stringBuffer.toString();
            if (this.getPlaceHolderCount() > 0) {
                string2 = string2.replaceAll("\\?", "NULL");
            }
            this.m_prep = this.m_con.prepareStatement(string2);
            ResultSet resultSet = this.m_prep.executeQuery();
            CursorData cursorData = this.getProtoType(resultSet.getMetaData());
            return cursorData;
        }
        catch (SQLException sQLException) {
            throw new DataException(1, (Throwable)sQLException);
        }
        finally {
            try {
                this.m_resultClosed = false;
                this.m_prep.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public List retrieveList() throws DataException {
        return this.retrieveList(null);
    }

    public List retrieveList(Condition condition) throws DataException {
        Vector<CursorData> vector = new Vector<CursorData>();
        try {
            Cloneable cloneable;
            Object object;
            Object object2;
            if (condition == null) {
                this.m_prep = this.getPreparedStatement(this.m_con, this.m_select.toString());
            } else if (condition != null && condition instanceof SqlCondition) {
                object2 = new StringBuffer();
                object = (SqlCondition)condition;
                if (!StringHelper.isEmpty((String)this.m_select.getWhere())) {
                    ((StringBuffer)object2).append(this.m_select.getWhere());
                }
                if (this.m_select.getGroupBy() != null) {
                    ((StringBuffer)object2).append(this.m_select.getGroupBy());
                }
                if (this.m_select.getHaving() != null) {
                    ((StringBuffer)object2).append(this.m_select.getHaving());
                }
                if (this.m_select.getOrderBy() != null) {
                    ((StringBuffer)object2).append(this.m_select.getOrderBy());
                }
                if (((StringBuffer)object2).length() > 0) {
                    ((SqlCondition)object).setPreparedQuery(((StringBuffer)object2).toString());
                }
                cloneable = this.getParameters();
                for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                    ((SqlCondition)object).addParameter(i + 1, ((ArrayList)cloneable).get(i));
                }
                this.m_prep = ((SqlCondition)object).getPreparedStatement(this.m_con, this.m_select.getColumns() + this.m_select.getFrom());
            }
            object2 = this.m_prep.executeQuery();
            object = this.getProtoType(object2.getMetaData());
            if (this.m_resultClosed) {
                object2.close();
                object2 = this.m_prep.executeQuery();
            }
            while (object2.next()) {
                cloneable = this.getObject((CursorData)object, (ResultSet)object2);
                vector.add((CursorData)cloneable);
            }
            object2.close();
            if (vector.isEmpty()) {
                vector = null;
            }
        }
        catch (SQLException sQLException) {
            throw new DataException(1, (Throwable)sQLException);
        }
        finally {
            try {
                this.m_resultClosed = false;
                this.m_prep.close();
            }
            catch (SQLException sQLException) {}
        }
        return vector;
    }

    public int update(CursorData cursorData) throws DataException {
        try {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("UPDATE ").append(this.m_select.getFrom().substring(this.m_select.getFrom().indexOf("FROM") + 4).trim());
            stringBuffer.append(" SET ");
            for (int i = 0; i < cursorData.getColumnCount(); ++i) {
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(cursorData.getColumn(i)).append(" = ?");
            }
            stringBuffer.append(" WHERE ");
            List list = this.retrieveList(null);
            CursorData cursorData2 = null;
            boolean bl = false;
            for (n2 = 0; n2 < list.size(); ++n2) {
                cursorData2 = (CursorData)list.get(n2);
                if (cursorData2.hashCode() != cursorData.getChecksum()) continue;
                bl = true;
                break;
            }
            cursorData.hashCode();
            cursorData2.hashCode();
            if (!bl || cursorData2.getChecksum() != cursorData.getChecksum()) {
                throw new SQLException("cursor is no longer valid");
            }
            n2 = 0;
            for (n = 0; n < cursorData2.getColumnCount(); ++n) {
                if (n2 != 0 && cursorData2.getColumnType(n) != (class$java$sql$Clob == null ? SqlCursor.class$("java.sql.Clob") : class$java$sql$Clob) && cursorData2.getColumnType(n) != (class$java$sql$Blob == null ? SqlCursor.class$("java.sql.Blob") : class$java$sql$Blob) && cursorData2.getColumnType(n) != (class$org$brains2b$sql$meta$types$Stream == null ? SqlCursor.class$("org.brains2b.sql.meta.types.Stream") : class$org$brains2b$sql$meta$types$Stream)) {
                    stringBuffer.append(" AND ");
                }
                if (cursorData2.getValue(n) != null) {
                    if (cursorData2.getColumnType(n) == (class$java$sql$Clob == null ? SqlCursor.class$("java.sql.Clob") : class$java$sql$Clob) || cursorData2.getColumnType(n) == (class$java$sql$Blob == null ? SqlCursor.class$("java.sql.Blob") : class$java$sql$Blob) || cursorData2.getColumnType(n) == (class$org$brains2b$sql$meta$types$Stream == null ? SqlCursor.class$("org.brains2b.sql.meta.types.Stream") : class$org$brains2b$sql$meta$types$Stream)) continue;
                    stringBuffer.append(cursorData2.getColumn(n)).append(" = ?");
                    ++n2;
                    continue;
                }
                stringBuffer.append(cursorData2.getColumn(n)).append(" IS NULL");
            }
            Logger.println((String)stringBuffer.toString(), (int)16);
            this.m_prep = this.m_con.prepareStatement(stringBuffer.toString());
            for (n = 0; n < cursorData.getColumnCount(); ++n) {
                if (cursorData.getValue(n) != null || cursorData.getValue(n) instanceof Stream && ((Stream)cursorData.getValue(n)).isAccessed()) {
                    if (cursorData.getColumnType(n) == (class$java$sql$Clob == null ? SqlCursor.class$("java.sql.Clob") : class$java$sql$Clob)) {
                        this.m_prep.setCharacterStream(n + 1, ((Clob)cursorData.getValue(n)).getCharacterStream(), 0);
                        continue;
                    }
                    if (cursorData.getColumnType(n) == (class$java$sql$Blob == null ? SqlCursor.class$("java.sql.Blob") : class$java$sql$Blob)) {
                        this.m_prep.setBinaryStream(n + 1, ((Blob)cursorData.getValue(n)).getBinaryStream(), 0);
                        continue;
                    }
                    if (cursorData.getColumnType(n) == (class$org$brains2b$sql$meta$types$Stream == null ? SqlCursor.class$("org.brains2b.sql.meta.types.Stream") : class$org$brains2b$sql$meta$types$Stream)) {
                        this.m_prep.setBinaryStream(n + 1, ((Stream)cursorData.getValue(n)).getInputStream(), 0);
                        continue;
                    }
                    this.m_prep.setObject(n + 1, cursorData.getValue(n));
                    continue;
                }
                this.m_prep.setNull(n + 1, this.getTypeInfo().getDataType(cursorData.getColumnType(n)));
            }
            n2 = 0;
            for (n = 0; n < cursorData2.getColumnCount(); ++n) {
                if (cursorData2.getValue(n) == null || cursorData2.getColumnType(n) == (class$java$sql$Clob == null ? SqlCursor.class$("java.sql.Clob") : class$java$sql$Clob) || cursorData2.getColumnType(n) == (class$java$sql$Blob == null ? SqlCursor.class$("java.sql.Blob") : class$java$sql$Blob) || cursorData2.getColumnType(n) == (class$org$brains2b$sql$meta$types$Stream == null ? SqlCursor.class$("org.brains2b.sql.meta.types.Stream") : class$org$brains2b$sql$meta$types$Stream)) continue;
                this.m_prep.setObject(n2++ + 1 + cursorData.getColumnCount(), cursorData2.getValue(n));
            }
            n = this.m_prep.executeUpdate();
            this.m_prep.close();
            cursorData.setChecksum(cursorData.hashCode());
            return n;
        }
        catch (SQLException sQLException) {
            throw new DataException(3, (Throwable)sQLException);
        }
    }

    public int delete(CursorData cursorData) throws DataException {
        try {
            int n;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("DELETE ").append(this.m_select.getFrom());
            stringBuffer.append(" WHERE ");
            for (n2 = 0; n2 < cursorData.getColumnCount(); ++n2) {
                if (n2 != 0) {
                    stringBuffer.append(" AND ");
                }
                if (cursorData.getValue(n2) != null) {
                    stringBuffer.append(cursorData.getColumn(n2)).append("= ?");
                    continue;
                }
                stringBuffer.append(cursorData.getColumn(n2)).append(" IS NULL");
            }
            Logger.println((String)stringBuffer.toString(), (int)16);
            this.m_prep = this.m_con.prepareStatement(stringBuffer.toString());
            n2 = 1;
            for (n = 0; n < cursorData.getColumnCount(); ++n) {
                if (cursorData.getValue(n) == null) continue;
                this.m_prep.setObject(n2++, cursorData.getValue(n));
            }
            n = this.m_prep.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            throw new DataException(4, (Throwable)sQLException);
        }
        finally {
            try {
                this.m_prep.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public int insert(CursorData cursorData) throws DataException {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO ").append(this.m_select.getFrom().substring(this.m_select.getFrom().indexOf("FROM") + 4).trim());
            stringBuffer.append(" ( ");
            int n2 = 0;
            for (n = 0; n < cursorData.getColumnCount(); ++n) {
                if (cursorData.getValue(n) == null) continue;
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(cursorData.getColumn(n));
                ++n2;
            }
            stringBuffer.append(" ) VALUES ( ");
            n2 = 0;
            for (n = 0; n < cursorData.getColumnCount(); ++n) {
                if (cursorData.getValue(n) == null && (!(cursorData.getValue(n) instanceof Stream) || !((Stream)cursorData.getValue(n)).isAccessed())) continue;
                if (n2 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("?");
                ++n2;
            }
            stringBuffer.append(" )");
            Logger.println((String)stringBuffer.toString(), (int)16);
            n2 = 0;
            this.m_prep = this.m_con.prepareStatement(stringBuffer.toString());
            for (n = 0; n < cursorData.getColumnCount(); ++n) {
                if (cursorData.getValue(n) == null) continue;
                if (cursorData.getColumnType(n) == (class$java$sql$Clob == null ? SqlCursor.class$("java.sql.Clob") : class$java$sql$Clob)) {
                    this.m_prep.setCharacterStream(n + 1, ((Clob)cursorData.getValue(n)).getCharacterStream(), 0);
                    continue;
                }
                if (cursorData.getColumnType(n) == (class$java$sql$Blob == null ? SqlCursor.class$("java.sql.Blob") : class$java$sql$Blob)) {
                    this.m_prep.setBinaryStream(n + 1, ((Blob)cursorData.getValue(n)).getBinaryStream(), 0);
                    continue;
                }
                if (cursorData.getColumnType(n) == (class$org$brains2b$sql$meta$types$Stream == null ? SqlCursor.class$("org.brains2b.sql.meta.types.Stream") : class$org$brains2b$sql$meta$types$Stream) && ((Stream)cursorData.getValue(n)).isAccessed()) {
                    this.m_prep.setBinaryStream(n + 1, ((Stream)cursorData.getValue(n)).getInputStream(), 0);
                    continue;
                }
                this.m_prep.setObject(++n2, cursorData.getValue(n));
            }
            n = this.m_prep.executeUpdate();
            this.m_prep.close();
            cursorData.setChecksum(cursorData.hashCode());
            int n3 = n;
            return n3;
        }
        catch (SQLException sQLException) {
            throw new DataException(2, (Throwable)sQLException);
        }
        finally {
            try {
                this.m_prep.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void addParameter(int n, int n2) {
        this.addParameter(n, new Integer(n2));
    }

    public void addParameter(int n, long l) {
        this.addParameter(n, new Long(l));
    }

    public void addParameter(int n, double d) {
        this.addParameter(n, new Double(d));
    }

    public void addParameter(int n, Object object) {
        if (object instanceof Date) {
            object = new Timestamp(((Date)object).getTime());
        }
        if (this.m_parameters == null && this.getPlaceHolderCount() > 0) {
            this.m_parameters = new ArrayList(this.getPlaceHolderCount());
        }
        if (object == null) {
            object = "NULL";
        }
        if (this.m_parameters.size() < n) {
            this.m_parameters.ensureCapacity(this.getPlaceHolderCount());
            this.m_parameters.add(n - 1, object);
        } else {
            this.m_parameters.set(n - 1, object);
        }
    }

    public void reset() {
        this.m_parameters.clear();
    }

    private ArrayList getParameters() throws SQLException {
        ArrayList arrayList = new ArrayList();
        if (this.m_parameters != null) {
            if (this.m_parameters.size() != this.getPlaceHolderCount()) {
                throw new SQLException("DataC: Not all variables bound");
            }
            arrayList.addAll(this.m_parameters);
        }
        return arrayList;
    }

    private int getPlaceHolderCount() {
        if (this.m_select.toString() == null || this.m_select.toString().length() == 0) {
            return -1;
        }
        int n = 0;
        int n2 = this.m_select.toString().indexOf(63);
        while (n2 != -1) {
            ++n;
            n2 = this.m_select.toString().indexOf(63, n2 + 1);
        }
        return n;
    }

    public PreparedStatement getPreparedStatement(Connection connection, String string) throws SQLException {
        String string2 = string;
        Logger.println((String)string2, (int)16);
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setMaxRows(5000);
        ArrayList arrayList = this.getParameters();
        for (int i = 0; i < arrayList.size(); ++i) {
            preparedStatement.setObject(i + 1, arrayList.get(i));
        }
        return preparedStatement;
    }

    public void setConnection(Connection connection) {
        this.m_con = connection;
    }

    protected CursorData getProtoType(ResultSetMetaData resultSetMetaData) throws SQLException {
        if (this.m_prototype == null) {
            this.m_prototype = new CursorData(this.getName());
            for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                int n = 0;
                try {
                    n = resultSetMetaData.getPrecision(i + 1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.m_prototype.setColumn(i, resultSetMetaData.getColumnLabel(i + 1));
                this.m_prototype.setColumnType(i, this.getTypeInfo().getJavaType(resultSetMetaData.getColumnType(i + 1), n, resultSetMetaData.getScale(i + 1)));
                if ((resultSetMetaData.getColumnType(i + 1) == -1 || resultSetMetaData.getColumnType(i + 1) == -4) && "Oracle".equals(this.m_con.getMetaData().getDatabaseProductName())) {
                    this.m_resultClosed = true;
                }
                int n2 = resultSetMetaData.getScale(i + 1) > 0 ? resultSetMetaData.getScale(i + 1) : 0;
                int n3 = resultSetMetaData.getColumnDisplaySize(i + 1);
                n3 = n == 0 ? (n3 < 0 ? Integer.MAX_VALUE : n3) : n;
                this.m_prototype.setValue(i, (Object)new BigDecimal("" + n3 + "." + n2));
            }
        }
        return this.m_prototype;
    }

    public String toString() {
        return this.m_select.toString();
    }

    public Connection getConnection() {
        return this.m_con;
    }

    public SelectDescriptor getSelect() {
        return this.m_select;
    }

    private TypesInfo getTypeInfo() {
        if (this.m_typeInfo == null) {
            this.m_typeInfo = new TypesInfo(this.m_con);
        }
        return this.m_typeInfo;
    }
}

