/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.cursor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.brains2b.data.HashCodeHelper;
import org.brains2b.data.OptimisticLock;

public class CursorData
implements OptimisticLock,
Cloneable {
    private final int serialID = 13;
    private int m_checksum;
    private int m_rowNo;
    private String m_name;
    private List m_columns;
    private List m_values;
    private List m_columnTypes;

    public CursorData(String string) {
        this.m_name = string;
        this.m_columns = new ArrayList();
        this.m_columnTypes = new ArrayList();
        this.m_values = new ArrayList();
    }

    public int getColumnCount() {
        return this.m_columns.size();
    }

    public void setColumn(int n, String string) {
        this.setToList(this.m_columns, n, string);
    }

    public String getColumn(int n) {
        return (String)this.m_columns.get(n);
    }

    public void setColumnType(int n, Class clazz) {
        this.setToList(this.m_columnTypes, n, clazz);
    }

    public Class getColumnType(String string) {
        return this.getColumnType(this.getIndex(string));
    }

    public Class getColumnType(int n) {
        if (n < this.m_columnTypes.size()) {
            return (Class)this.m_columnTypes.get(n);
        }
        return null;
    }

    public void setValue(int n, Object object) {
        if (n < 0) {
            return;
        }
        this.setToList(this.m_values, n, object);
    }

    public void setValue(String string, Object object) {
        this.setValue(this.getIndex(string), object);
    }

    public void setColumnValue(int n, String string, Object object) {
        this.setColumn(n, string);
        this.setValue(n, object);
    }

    public Object getValue(int n) {
        if (n >= 0 && n < this.m_values.size()) {
            return this.m_values.get(n);
        }
        return null;
    }

    public double getDoubleValue(int n) {
        if (this.getValue(n) == null) {
            return 0.0;
        }
        if (this.m_values.get(n) instanceof BigDecimal) {
            return ((BigDecimal)this.m_values.get(n)).doubleValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public double getDoubleValue(String string) {
        return this.getDoubleValue(this.getIndex(string));
    }

    public int getIntValue(int n) {
        if (this.getValue(n) == null) {
            return 0;
        }
        if (this.m_values.get(n) instanceof BigDecimal) {
            return ((BigDecimal)this.m_values.get(n)).intValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public long getLongValue(int n) {
        if (this.getValue(n) == null) {
            return 0L;
        }
        if (this.m_values.get(n) instanceof BigDecimal) {
            return ((BigDecimal)this.m_values.get(n)).longValue();
        }
        throw new NumberFormatException("Value is not a number");
    }

    public long getLongValue(String string) {
        return this.getLongValue(this.getIndex(string));
    }

    public Object getValue(String string) {
        return this.m_values.get(this.getIndex(string));
    }

    public int getIntValue(String string) {
        return this.getIntValue(this.getIndex(string));
    }

    private int getIndex(String string) {
        for (int i = 0; i < this.m_columns.size(); ++i) {
            if (!this.m_columns.get(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getChecksum() {
        return this.m_checksum;
    }

    public void setChecksum(int n) {
        this.m_checksum = n;
    }

    public int hashCode() {
        int n = 13;
        for (int i = 0; i < this.m_columns.size(); ++i) {
            Object object = this.getValue(i);
            if (object == null) continue;
            n = HashCodeHelper.hash(n, object);
        }
        return n;
    }

    public Object clone() {
        CursorData cursorData = new CursorData(this.m_name);
        cursorData.m_columns = this.m_columns;
        cursorData.m_columnTypes = this.m_columnTypes;
        return cursorData;
    }

    public Object cloneAll() {
        CursorData cursorData = new CursorData(this.m_name);
        cursorData.m_columns = this.m_columns;
        cursorData.m_columnTypes = this.m_columnTypes;
        cursorData.m_values = this.m_values;
        return cursorData;
    }

    public int getRowNo() {
        return this.m_rowNo;
    }

    public void setRowNo(int n) {
        this.m_rowNo = n;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public boolean equals(Object object) {
        return this.hashCode() == object.hashCode();
    }

    public int serialID() {
        return 13;
    }

    private final void setToList(List list, int n, Object object) {
        if (n < list.size()) {
            list.set(n, object);
        } else {
            for (int i = list.size(); i < n; ++i) {
                list.add(i, null);
            }
            list.add(n, object);
        }
    }
}

