/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.data.cursor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.brains2b.data.Condition;
import org.brains2b.data.DataException;
import org.brains2b.data.cursor.CursorData;
import org.brains2b.log.Logger;

public abstract class Cursor {
    private String m_name;
    protected CursorData m_prototype;

    public Cursor(String string) {
        this.m_name = string;
    }

    public CursorData getNewCursorData() {
        if (this.m_prototype == null) {
            try {
                this.m_prototype = this.getProtoType();
            }
            catch (Exception exception) {
                Logger.printException((Exception)exception);
                return null;
            }
        }
        return (CursorData)this.m_prototype.clone();
    }

    public abstract CursorData getProtoType() throws DataException;

    protected CursorData getObject(CursorData cursorData, ResultSet resultSet) throws SQLException {
        CursorData cursorData2 = (CursorData)cursorData.clone();
        cursorData2.setRowNo(resultSet.getRow());
        for (int i = 0; i < cursorData2.getColumnCount(); ++i) {
            cursorData2.setValue(i, resultSet.getObject(i + 1));
        }
        cursorData2.setChecksum(cursorData2.hashCode());
        return cursorData2;
    }

    public String getName() {
        return this.m_name;
    }

    public abstract int update(CursorData var1) throws DataException;

    public abstract int insert(CursorData var1) throws DataException;

    public abstract int delete(CursorData var1) throws DataException;

    public abstract CursorData retrieve(Condition var1) throws DataException;

    public abstract List retrieveList(Condition var1) throws DataException;

    public abstract List retrieveList() throws DataException;
}

