/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

public class HexHelper {
    private static final char[] CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final String encode(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("no bytes to digest");
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i * 2] = CHARS[(0xF0 & byArray[i]) / 16];
            cArray[i * 2 + 1] = CHARS[(0xF & byArray[i]) % 16];
        }
        return new String(cArray);
    }

    public static final byte[] decode(String string) {
        if (string == null) {
            throw new NullPointerException("no String to digest");
        }
        if (string.startsWith("0x")) {
            string = string.substring(2);
        }
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(Character.digit(cArray[i * 2], 16) * 16 + Character.digit(cArray[i * 2 + 1], 16));
        }
        return byArray;
    }
}

