/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.brains2b.util.StringHelper;

public class GuiHelper {
    private GuiHelper() {
    }

    public static Rectangle setMiddle(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            throw new IllegalArgumentException("Cannot calculate middle if source or target is null");
        }
        rectangle.x = (int)rectangle2.getCenterX() - rectangle.width / 2;
        rectangle.y = (int)rectangle2.getCenterY() - rectangle.height / 2;
        return rectangle;
    }

    public static final Dimension decodeDimension(String string) {
        if (StringHelper.isEmpty(string)) {
            return null;
        }
        Dimension dimension = new Dimension();
        try {
            int n = string.indexOf(44);
            if (n == -1) {
                dimension.width = Integer.parseInt(string);
                dimension.height = Integer.parseInt(string);
            } else {
                dimension.width = Integer.parseInt(string.substring(0, n));
                dimension.height = Integer.parseInt(string.substring(n + 1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            dimension = null;
        }
        return dimension;
    }

    public static final String encodeDimension(Dimension dimension) {
        if (dimension == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(dimension.width).append(',').append(dimension.height);
        return stringBuffer.toString();
    }

    public static int getWidth(String string) {
        if (string == null) {
            return 0;
        }
        JLabel jLabel = new JLabel();
        string = string + "M";
        int n = SwingUtilities.computeStringWidth(jLabel.getFontMetrics(jLabel.getFont()), string);
        return n;
    }

    public static int getWidth(String string, int n) {
        int n2 = GuiHelper.getWidth(string);
        return n2 > n ? n2 : n;
    }

    public static boolean isColor(String string) {
        try {
            Color color = Color.decode(string);
            if (color != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isFont(String string) {
        if (string == null) {
            return false;
        }
        try {
            Font font = Font.decode(string);
            if (font != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

