/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.task;

import java.util.ArrayList;
import java.util.Stack;
import org.brains2b.task.Task;
import org.brains2b.task.TaskEvent;
import org.brains2b.task.TaskListener;

public abstract class DefaultTask
implements Task {
    private boolean m_finished = false;
    private int m_result = 0;
    private Stack m_messages;
    private ArrayList m_eventList = new ArrayList();
    private int m_max;
    private int m_min;
    private int m_pos;

    public boolean isFinished() {
        return this.m_finished;
    }

    public void setFinished(boolean bl) {
        boolean bl2 = this.m_finished;
        this.m_finished = bl;
        if (bl2 != bl) {
            TaskEvent taskEvent = new TaskEvent(this, 1);
            taskEvent.setFinished(bl);
            this.fireTaskEvent(taskEvent);
        }
    }

    public int getResult() {
        return this.m_result;
    }

    protected void setResult(int n) {
        this.m_result = n;
    }

    public Stack getMessages() {
        return this.m_messages;
    }

    protected void addMessage(String string) {
        if (this.m_messages == null) {
            this.m_messages = new Stack();
        }
        this.m_messages.add(string);
    }

    protected void addException(Throwable throwable) {
        if (this.m_messages == null) {
            this.m_messages = new Stack();
        }
        this.m_messages.add(throwable);
    }

    public int getMax() {
        return this.m_max;
    }

    public int getMin() {
        return this.m_min;
    }

    public int getPosition() {
        return this.m_pos;
    }

    public void addTaskListener(TaskListener taskListener) {
        this.m_eventList.add(taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        this.m_eventList.remove(taskListener);
    }

    protected void progress() {
        this.progress(++this.m_pos);
    }

    protected void progress(int n) {
        if (!this.isFinished()) {
            this.m_pos = n;
            if (this.m_pos > this.m_max) {
                this.m_pos = this.m_max;
            }
            TaskEvent taskEvent = new TaskEvent(this, 0);
            taskEvent.setMax(this.m_max);
            taskEvent.setMin(this.m_min);
            taskEvent.setPosition(this.m_pos);
            taskEvent.setFinished(this.m_finished);
            this.fireTaskEvent(taskEvent);
        }
    }

    protected void fireTaskEvent(TaskEvent taskEvent) {
        for (int i = 0; i < this.m_eventList.size(); ++i) {
            ((TaskListener)this.m_eventList.get(i)).taskProgressed(taskEvent);
        }
    }

    protected void setMax(int n) {
        this.m_max = n;
    }

    protected void setMin(int n) {
        this.m_min = n;
    }
}

