/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.brains2b.console.ArgumentException;

public class ArgumentMap {
    private ArrayList m_args = new ArrayList();

    public void addArgument(String string, boolean bl) {
        ArgumentEntry argumentEntry = new ArgumentEntry(string, '0', bl, null);
        this.m_args.add(argumentEntry);
    }

    public void addArgument(String string, String string2) {
        ArgumentEntry argumentEntry = new ArgumentEntry(string, '0', true, null);
        argumentEntry.setDefaultValue(string2);
        this.m_args.add(argumentEntry);
    }

    public void addOption(String string, char c, boolean bl) {
        this.m_args.add(new ArgumentEntry(string, c, bl, null));
    }

    public void addArgumentTo(String string, String string2, boolean bl) {
        this.m_args.add(new ArgumentEntry(string2, '0', bl, string));
        this.getEntry(string).addChild(string2);
    }

    public void addOptionTo(String string, String string2, char c) {
        this.m_args.add(new ArgumentEntry(string2, c, false, string));
        this.getEntry(string).addChild(string2);
    }

    public Map getList(String[] stringArray) throws ArgumentException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.processArgs(stringArray);
        Iterator iterator = this.m_args.iterator();
        while (iterator.hasNext()) {
            ArgumentEntry argumentEntry = (ArgumentEntry)iterator.next();
            if (argumentEntry.getParent() == null && argumentEntry.getValue() != null) {
                hashMap.put(argumentEntry.getName(), argumentEntry.getValue());
                continue;
            }
            if (argumentEntry.getParent() != null || !argumentEntry.isRequired()) continue;
            throw new ArgumentException(argumentEntry.getName(), "A required argument is missing");
        }
        return hashMap;
    }

    private boolean isLong(String string) {
        return string.charAt(0) == '-' && string.charAt(1) == '-';
    }

    private void processArgs(String[] stringArray) throws ArgumentException {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ArgumentEntry argumentEntry = null;
            if (this.isLong(stringArray[i])) {
                argumentEntry = this.findLong(stringArray[i]);
                if (argumentEntry != null && this.processArg(argumentEntry, i + 1 < n ? stringArray[i + 1] : null)) {
                    ++i;
                }
            } else if (this.isShort(stringArray[i])) {
                for (int j = 1; j < stringArray[i].length(); ++j) {
                    argumentEntry = this.findShort(stringArray[i], j);
                    if (argumentEntry == null || !this.processArg(argumentEntry, i + 1 < n ? stringArray[i + 1] : null)) continue;
                    ++i;
                    break;
                }
            } else {
                argumentEntry = this.findNextWord();
                if (argumentEntry != null) {
                    argumentEntry.setValue(stringArray[i]);
                }
            }
            if (argumentEntry != null) continue;
            throw new ArgumentException(stringArray[i], "Not recognized as an argument");
        }
    }

    private boolean processArg(ArgumentEntry argumentEntry, String string) throws ArgumentException {
        if (argumentEntry.getChildren() != null) {
            ArgumentEntry argumentEntry2 = this.getEntry((String)argumentEntry.getChildren().get(0));
            if (string != null && !this.isLong(string) && !this.isShort(string)) {
                argumentEntry.setValue(string);
                return true;
            }
            if (argumentEntry2.isRequired()) {
                throw new ArgumentException(argumentEntry.getParent(), "A required argument is missing");
            }
        } else if (argumentEntry.getParent() != null) {
            ArgumentEntry argumentEntry3 = this.getEntry(argumentEntry.getParent());
            if (argumentEntry3.getValue() == null || argumentEntry3.getValue() == argumentEntry3.getDefaultValue()) {
                argumentEntry3.setValue(argumentEntry.getName());
            }
        } else {
            argumentEntry.setValue("true");
        }
        return false;
    }

    private boolean isShort(String string) {
        return string.charAt(0) == '-' && Character.isLetterOrDigit(string.charAt(1));
    }

    private ArgumentEntry findLong(String string) {
        return this.getEntry(string.substring(2));
    }

    private ArgumentEntry findShort(String string, int n) {
        char c = string.charAt(n);
        Iterator iterator = this.m_args.iterator();
        while (iterator.hasNext()) {
            ArgumentEntry argumentEntry = (ArgumentEntry)iterator.next();
            if (argumentEntry.getShortKey() != c) continue;
            return argumentEntry;
        }
        return null;
    }

    private ArgumentEntry findNextWord() {
        Iterator iterator = this.m_args.iterator();
        while (iterator.hasNext()) {
            ArgumentEntry argumentEntry = (ArgumentEntry)iterator.next();
            if (argumentEntry.getShortKey() != '0' || argumentEntry.getParent() != null || argumentEntry.getChildren() != null || argumentEntry.getValue() != null) continue;
            return argumentEntry;
        }
        return null;
    }

    private final ArgumentEntry getEntry(String string) {
        Iterator iterator = this.m_args.iterator();
        while (iterator.hasNext()) {
            ArgumentEntry argumentEntry = (ArgumentEntry)iterator.next();
            if (!string.equals(argumentEntry.getName())) continue;
            return argumentEntry;
        }
        return null;
    }

    class ArgumentEntry {
        private String m_name;
        private char m_shortKey;
        private boolean m_required;
        private String m_parent;
        private String m_default;
        private String m_value;
        private ArrayList m_children;

        public ArgumentEntry(String string, char c, boolean bl, String string2) {
            this.m_name = string;
            this.m_shortKey = c;
            this.m_required = bl;
            this.m_parent = string2;
        }

        public char getShortKey() {
            return this.m_shortKey;
        }

        public void addChild(String string) {
            if (this.m_children == null) {
                this.m_children = new ArrayList();
            }
            this.m_children.add(string);
        }

        public List getChildren() {
            return this.m_children;
        }

        public String getName() {
            return this.m_name;
        }

        public String getParent() {
            return this.m_parent;
        }

        public String getDefaultValue() {
            return this.m_default;
        }

        public String getValue() {
            return this.m_value;
        }

        public void setValue(String string) {
            this.m_value = string;
        }

        public void setDefaultValue(String string) {
            this.m_default = string;
            this.m_value = string;
        }

        public boolean isRequired() {
            return this.m_required;
        }
    }
}

