/*
 * Decompiled with CFR 0.152.
 */
package org.brains2b.resx;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public class ExtResourceBundle
extends ResourceBundle {
    private static HashMap m_cache = new HashMap();
    private HashMap m_contents;
    protected String m_domain;
    protected Locale m_locale;
    protected static Connection m_con;
    static /* synthetic */ Class class$org$brains2b$resx$ExtResourceBundle;

    public ExtResourceBundle(String string, Locale locale) {
        if (string != null) {
            this.m_domain = string.toUpperCase();
        }
        this.m_locale = locale == null ? new Locale("", "") : locale;
    }

    public static ResourceBundle getExtBundle(String string) {
        return ExtResourceBundle.getBundleImpl(new ExtResourceBundle(string, Locale.getDefault()));
    }

    public static ResourceBundle getExtBundle(String string, Locale locale) {
        return ExtResourceBundle.getBundleImpl(new ExtResourceBundle(string, locale));
    }

    protected static ResourceBundle getBundleImpl(ExtResourceBundle extResourceBundle) {
        try {
            return ResourceBundle.getBundle(extResourceBundle.getBaseName(), extResourceBundle.getLocale());
        }
        catch (MissingResourceException missingResourceException) {
            Locale locale = extResourceBundle.getLocale();
            String string = extResourceBundle.getBaseName();
            ExtResourceBundle extResourceBundle2 = ExtResourceBundle.findInCache(string, locale);
            if (extResourceBundle2 != null) {
                return extResourceBundle2;
            }
            if (m_con == null) {
                try {
                    extResourceBundle.makeConnection();
                }
                catch (SQLException sQLException) {
                    throw new MissingResourceException("Could not find ResourceBundle due to:" + sQLException.getMessage(), (class$org$brains2b$resx$ExtResourceBundle == null ? (class$org$brains2b$resx$ExtResourceBundle = ExtResourceBundle.class$("org.brains2b.resx.ExtResourceBundle")) : class$org$brains2b$resx$ExtResourceBundle).getName(), null);
                }
            }
            ResourceBundle resourceBundle = extResourceBundle.getParent();
            extResourceBundle.setParent(resourceBundle);
            ExtResourceBundle.addToCache(extResourceBundle);
            return extResourceBundle;
        }
    }

    private static ExtResourceBundle findInCache(String string, Locale locale) {
        SoftReference softReference = (SoftReference)m_cache.get(ExtResourceBundle.getCacheKey(string, locale));
        if (softReference != null) {
            return (ExtResourceBundle)softReference.get();
        }
        return null;
    }

    private static void addToCache(ExtResourceBundle extResourceBundle) {
        m_cache.put(ExtResourceBundle.getCacheKey(extResourceBundle.getBaseName(), extResourceBundle.getLocale()), new SoftReference<ExtResourceBundle>(extResourceBundle));
    }

    private static final String getCacheKey(String string, Locale locale) {
        return string + '.' + locale.toString();
    }

    protected ResourceBundle getParent() {
        ResourceBundle resourceBundle = null;
        if (!this.getLocale().getLanguage().equals("")) {
            if (!this.getLocale().getCountry().equals("")) {
                Locale locale = new Locale(this.getLocale().getLanguage(), "");
                resourceBundle = ExtResourceBundle.getExtBundle(this.getBaseName(), locale);
            } else {
                resourceBundle = ExtResourceBundle.getExtBundle(this.getBaseName(), new Locale("", ""));
            }
        }
        return resourceBundle;
    }

    protected Object handleGetObject(String string) {
        if (this.m_contents == null) {
            this.loadContents();
            if (this.m_contents == null) {
                throw new MissingResourceException("Can't find resource for  " + this.m_domain + "." + string, this.m_domain, string);
            }
        }
        return this.m_contents.get(string);
    }

    public Enumeration getKeys() {
        if (this.m_contents == null) {
            this.loadContents();
        }
        if (this.parent != null) {
            Vector vector = new Vector(this.m_contents.keySet());
            Enumeration<String> enumeration = this.parent.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (vector.contains(string)) continue;
                vector.add(string);
            }
            return vector.elements();
        }
        return new Vector(this.m_contents.keySet()).elements();
    }

    protected void makeConnection() throws SQLException {
        String string = System.getProperty("sql.driver");
        String string2 = System.getProperty("sql.url");
        String string3 = System.getProperty("sql.user");
        String string4 = System.getProperty("sql.password");
        if (string == null || string2 == null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream("connection.properties"));
            }
            catch (IOException iOException) {
                throw new SQLException("Cannot find required connection information");
            }
            string = properties.getProperty("sql.driver");
            string2 = properties.getProperty("sql.url");
            string3 = properties.getProperty("sql.user");
            string4 = properties.getProperty("sql.password");
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Could not find SQL Driver");
        }
        m_con = DriverManager.getConnection(string2, string3, string4);
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT RESKEY, RESVALUE FROM LOCALIZED_RESOURCE ");
        stringBuffer.append("WHERE DOMAIN='" + this.m_domain + "' ");
        if (this.m_locale != null) {
            stringBuffer.append("AND ");
            if (!this.m_locale.getLanguage().equals("")) {
                stringBuffer.append("LANGUAGE='" + this.m_locale.getLanguage() + "'");
            } else {
                stringBuffer.append("LANGUAGE IS NULL ");
            }
            if (!this.m_locale.getCountry().equals("")) {
                stringBuffer.append(" AND COUNTRY='" + this.m_locale.getCountry() + "'");
            } else {
                stringBuffer.append(" AND COUNTRY IS NULL ");
            }
        }
        return stringBuffer.toString();
    }

    private final synchronized void loadContents() {
        try {
            this.m_contents = new HashMap();
            if (m_con == null) {
                this.makeConnection();
            }
            Statement statement = m_con.createStatement();
            ResultSet resultSet = statement.executeQuery(this.getSQL());
            while (resultSet.next()) {
                this.m_contents.put(resultSet.getString(1), resultSet.getString(2) != null ? resultSet.getString(2) : "");
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.m_contents = new HashMap();
        }
    }

    protected HashMap getContents() {
        if (this.m_contents == null) {
            this.loadContents();
        }
        return this.m_contents;
    }

    protected Connection getConnection() throws SQLException {
        if (m_con == null) {
            this.makeConnection();
        }
        return m_con;
    }

    public String getBaseName() {
        return this.m_domain;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

