/* 	OracleCursorTest.java
 * 
 * Created on: May 8, 2003
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2003-2004, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 /* @#History
 * [When]		[Who]				[What]
 * Jan 6, 2004	dennis@brains2b.nl	Added Group tested	
 * 04-03-2004	dennis@brains2b.nl	Added testCursorDate
 * 07-04-2004	denns@brains2b.nl	Added test for update and delete
 */
package test.org.brains2b.sql.oracle.cursor;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Vector;

import junit.framework.TestCase;

import org.brains2b.data.cursor.CursorData;
import org.brains2b.sql.LocalConnector;
import org.brains2b.sql.oracle.cursor.OracleCursor;

/** Unit test for org.brains2b.sql.oracle.cursor.OracleCursor
 * 
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.21 [04-03-2004]
 * @see org.brains2b.data.sql.cursor.SqlCursor
 */
public class OracleCursorTest extends TestCase {

	private LocalConnector m_connector;

    /**
     * Constructor for OracleCursorTest.
     * @param arg0
     */
    public OracleCursorTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(OracleCursorTest.class);
    }

	public void setUp() {
		m_connector=new LocalConnector(
			"oracle.jdbc.driver.OracleDriver",
			" jdbc:oracle:thin:@arthur:1521:merlin",
			"scott",
			"miauw");
	}

    /*
     * Test for Vector select()
     */
    public void testSelect() {
    	try {
	    	OracleCursor c=new OracleCursor(m_connector.getConnection(), "TEST",
    			"SELECT ENAME AS NAME, DNAME AS DEPARTMENT FROM EMP,DEPT WHERE EMP.DEPTNO=DEPT.DEPTNO AND EMP.EMPNO=?");
	    	c.addParameter(1,7788);
    		Vector v=c.select();
    		assertEquals(1,v.size());
    		CursorData cd=(CursorData) v.get(0);
    		assertEquals(2,cd.getColumnCount());
    		assertEquals("NAME",cd.getColumn(0));
    		assertEquals("DEPARTMENT",cd.getColumn(1));
    		assertEquals("SCOTT",cd.getValue("NAME"));
			assertEquals("RESEARCH",cd.getValue("DEPARTMENT"));
    	} catch (Exception ex) {
    		assertTrue(ex.getClass() + " : " + ex.getMessage(),false);
    	}
    }

	public void testGroup() {
			try {
				OracleCursor c=new OracleCursor(m_connector.getConnection(), "TEST",
					"SELECT DEPT.DEPTNO, DNAME AS DEPARTMENT, COUNT(EMPNO) EMPLOYEES FROM DEPT,EMP WHERE DEPT.DEPTNO=EMP.DEPTNO GROUP BY DEPT.DEPTNO, DNAME");
				Vector v=c.select();
				assertEquals(3,v.size());
				//DEPTNO=40 has no employees
				CursorData cd=(CursorData) v.get(0);
				assertEquals(3,cd.getColumnCount());
				assertEquals(10,cd.getIntValue("DEPTNO"));
				assertEquals("ACCOUNTING", cd.getValue("DEPARTMENT"));
				assertEquals(3,cd.getIntValue("EMPLOYEES"));
			} catch (Exception ex) {
				ex.printStackTrace();
				assertTrue(ex.getClass() + " : " + ex.getMessage(),false);
			}
	}
	
	public void testCursorDataForGroup() {
				try {
					OracleCursor c=new OracleCursor(m_connector.getConnection(), "TEST",
						"SELECT DEPT.DEPTNO, DNAME AS DEPARTMENT, COUNT(EMPNO) EMPLOYEES FROM DEPT,EMP WHERE DEPT.DEPTNO=EMP.DEPTNO GROUP BY DEPT.DEPTNO, DNAME");
					CursorData cd=c.getNewCursorData();
					assertEquals(3,cd.getColumnCount());
					//set them to make sure the new cursor data can contain them
					//you cannot however insert them
					cd.setValue("DEPTNO","50");
					cd.setValue("DEPARTMENT","LEGAL");
					cd.setValue("EMPLOYEES","100");
					assertTrue(true);
				} catch (Exception ex) {
					ex.printStackTrace();
					assertTrue(ex.getClass() + " : " + ex.getMessage(),false);
				}
		}

	public void testCursorDate() {
		try {
			OracleCursor cursor=new OracleCursor(m_connector.getConnection(), "TEST",
				"SELECT COUNT(EMPNO) AS LOYAL FROM EMP WHERE HIREDATE < ?");
			Calendar c=Calendar.getInstance();
			c.set(1981,11,31);
			cursor.addParameter(1,c.getTime());
			Vector v = cursor.select();
			CursorData cd=(CursorData) v.get(0);
			assertEquals(1,v.size());
			assertEquals(11,cd.getIntValue("LOYAL"));
		} catch (Exception ex) {
			ex.printStackTrace();
			assertTrue(ex.getClass() + " : " + ex.getMessage(),false);
		}
	}
	
	public void testDelete() {
			try {
				m_connector.getConnection().setAutoCommit(false);
				OracleCursor cursor=new OracleCursor(m_connector.getConnection(), "TEST",
					"SELECT EMPNO,ENAME,SAL FROM EMP WHERE SAL < ?");
				cursor.addParameter(1,1000);
				Vector v = cursor.select();
				CursorData cd=(CursorData) v.get(0);
				assertEquals(7369,cd.getIntValue("EMPNO"));
				cursor.delete(cd);
				v = cursor.select();
				CursorData cd2=(CursorData) v.get(0);
				assertTrue(cd2.getIntValue("EMPNO")!=7369);
				assertTrue(!cd.equals(cd2));
			} catch (Exception ex) {
				ex.printStackTrace();
				assertTrue(ex.getClass() + " : " + ex.getMessage(),false);
			} finally {
				try {
					m_connector.getConnection().rollback();
				} catch (SQLException sqex) {
					sqex.printStackTrace();
				}
			}
		}
		
	public void testUpdate() {
			try {
				m_connector.getConnection().setAutoCommit(false);
				OracleCursor cursor=new OracleCursor(m_connector.getConnection(), "TEST",
					"SELECT EMPNO,ENAME,SAL FROM EMP WHERE SAL < ? ORDER BY EMPNO");
				cursor.addParameter(1,1000);
				Vector v = cursor.select();
				CursorData cd=(CursorData) v.get(0);
				assertEquals(7369,cd.getIntValue("EMPNO"));
				assertEquals(800,cd.getIntValue("SAL"));
				
				cd.setValue("SAL",new Integer(999));
				cursor.update(cd);
				v = cursor.select();
				CursorData cd2=(CursorData) v.get(0);
				assertEquals(7369,cd2.getIntValue("EMPNO"));
				assertEquals(999,cd2.getIntValue("SAL"));
			} catch (Exception ex) {
				ex.printStackTrace();
				assertTrue(ex.getClass() + " : " + ex.getMessage(),false);
			} finally {
				try {
					m_connector.getConnection().rollback();
				} catch (SQLException sqex) {
					sqex.printStackTrace();
				}
			}
		}

	
	/**
     * @see junit.framework.TestCase#tearDown()
     */
    public void tearDown() {
        try {
            m_connector.close();
        } catch (SQLException sqex){}
    }

}
