package test.org.brains2b.data.sql.lob;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

import junit.framework.TestCase;

import org.brains2b.sql.meta.types.Stream;

/**
 * Abstract class for testing Stream implementations
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.90 [21-03-2008]
 * @see ConnectedStreamTest
 * @see DisconnectedStreamTest
 */
public abstract class StreamTest extends TestCase {

	private final static String TEST = "Test string for Stream";
	
	protected InputStream m_is;
	
	protected void setUp() throws Exception {
		m_is = new ByteArrayInputStream(TEST.getBytes());
	}

	protected void tearDown() throws Exception {
		m_is.close();
	}

	public void testOnInput(Stream s) throws Exception {
		byte[] b = new byte[1024];
		int len = s.getInputStream().read(b);
		byte[] tb= TEST.getBytes();
		assertEquals(len, tb.length);
		byte[] lb = new byte[len];
		System.arraycopy(b,0,lb,0,len);
		assertTrue(Arrays.equals(lb, tb));
	}
	
	public void testOutput(Stream s) throws Exception {
		byte[] tb= TEST.getBytes();
		OutputStream os = s.getOutputStream();
		os.write(tb);
		os.close();
		byte[] b = new byte[1024];
		int len = s.getInputStream().read(b);
		
		assertEquals(len, tb.length);
		byte[] lb = new byte[len];
		System.arraycopy(b,0,lb,0,len);
		assertTrue(Arrays.equals(lb, tb));
	}
	
	public void testOverwrite(Stream s) throws Exception {
		byte[] b = new byte[1024];
		InputStream is = s.getInputStream();
		int len = is.read(b);
		is.close();
		byte[] tb= TEST.getBytes();
		assertEquals(len, tb.length);
		byte[] lb = new byte[len];
		System.arraycopy(b,0,lb,0,len);
		assertTrue(Arrays.equals(lb, tb));
		
		OutputStream os = s.getOutputStream();
		byte[] test = new byte[58];
		Arrays.fill(test, (byte) 17);
		os.write(test);
		os.close();
		
		len = s.getInputStream().read(b);
		
		assertEquals(len, test.length);
		lb = new byte[len];
		System.arraycopy(b,0,lb,0,len);
		assertTrue(Arrays.equals(lb, test));
		
	}
}
