/* 	ClobImplTest.java
 *	Copyright (c) 2008, Brains2B.org
 *	
 *	Created by: Dennis Groenendijk
 *	Created on: Mar 21, 2008
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that  * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test.org.brains2b.data.sql.lob;

import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;

import junit.framework.TestCase;

import org.brains2b.data.sql.lob.ClobImpl;

/**
 * Unit test for ClobImpl
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.90 [21-03-2008]
 */
public class ClobImplTest extends TestCase {
	private final static String TEST = "Overwrite content of Clob";
	private ClobImpl m_clob;
	
	protected void setUp() throws Exception {
		m_clob = new ClobImpl();
		byte[] b= new byte[4096];
		int len = 0;
		OutputStream os = m_clob.setAsciiStream(0);
		FileInputStream fis = new FileInputStream("doc/project.xml");
		while ( (len=fis.read(b))!=-1) {
			os.write(b, 0, len);		
		}
		os.close();
		fis.close();
		super.setUp();
	}
	
	public void testGetAsciiStream() {
		try {
			compareStream(new InputStreamReader(m_clob.getAsciiStream())
				,new FileReader("doc/project.xml"));
		} catch (Exception ex) {
			assertTrue(ex.getMessage(),false);
		}
	}

	public void testGetCharacterStream() {
		try {
			compareStream(m_clob.getCharacterStream()
				,new FileReader("doc/project.xml"));
		} catch (Exception ex) {
			assertTrue(ex.getMessage(),false);
		}
	}

	public void testGetSubString() {
		try {
			assertEquals("purpose in design was to have my",m_clob.getSubString(664, 32));
		} catch (Exception ex) {
			assertTrue(ex.getMessage(),false);
		}
		
	}

	public void testLength() {
		try {
			assertEquals(5340,m_clob.length());
		} catch (Exception ex) {
			assertTrue(ex.getMessage(),false);
		}
	}

	public void testPositionStringLong() {
		try {
			assertEquals(311 ,m_clob.position("<startdate>20-01-2002</startdate>",123));
			assertEquals(-1  ,m_clob.position("<startdate>20-01-2002</startdate>",2048));
		} catch (Exception ex) {
			assertTrue(ex.getMessage(),false);
		}
	}

	public void testPositionClobLong() {
		try {
			Clob clob = new ClobImpl();
			clob.setString(0, "<startdate>20-01-2002</startdate>");
			assertEquals(311 ,m_clob.position(clob,123));
			assertEquals(-1  ,m_clob.position(clob,2048));
		} catch (Exception ex) {
			assertTrue(ex.getMessage(),false);
		}
	}

	public void testSetCharacterStream() throws Exception {
		assertEquals(5340,m_clob.length());
		Writer w = m_clob.setCharacterStream(0L);
		w.write(TEST);
		w.close();
		assertEquals(25,m_clob.length());
		assertEquals(TEST,m_clob.getSubString(0L, 25));
		
		
	}

	public void testSetAsciiStream() throws Exception {
		assertEquals(5340,m_clob.length());
		OutputStream os = m_clob.setAsciiStream(0L);
		os.write(TEST.getBytes());
		os.close();
		assertEquals(25,m_clob.length());
		assertEquals(TEST,m_clob.getSubString(0L, 25));
	}

	public void testSetStringLongString() throws Exception {
		assertEquals(5340,m_clob.length());
		m_clob.setString(400L, TEST);
		assertEquals(TEST, m_clob.getSubString(400L, TEST.length()));
		assertEquals(425L,m_clob.length());
	}

	public void testSetStringLongStringIntInt() throws Exception {
		assertEquals(5340,m_clob.length());
		m_clob.setString(1931L, TEST,0,10);
		assertEquals(TEST.substring(0, 10), m_clob.getSubString(1931L,10));
		assertEquals(1941L,m_clob.length());
	}

	public void testTruncate() throws Exception {
		assertEquals(5340,m_clob.length());
		m_clob.truncate(1921L);
		assertEquals(1921,m_clob.length());
		m_clob.truncate(4000L);
		assertEquals(1921,m_clob.length());
	}

	private void compareStream(Reader rA, Reader rB) {
		char[] cA= new char[4096];
		char[] cB= new char[4096];
		int lenA = 0;
		int lenB = 0;
		try {
			while ( (lenA=rA.read(cA))!=-1) {
				lenB = rB.read(cB);
				assertEquals(lenA, lenB);
				compareCharacters(cA,cB);
			}
			rA.close();
			rB.close();
		} catch (IOException iex) {
			assertTrue(iex.getMessage(),false);
		}
	}
	
	private void compareCharacters(char[] cA, char[] cB) {
		for (int i=0;i<cA.length;i++) {
			assertEquals("Offset : " + i + " is different " + cA[i] +" " + cB[i],  cA[i],cB[i]);
		}
	}
}
