/* 	OracleDataHelperTest.java
 * 
 * Created on: 3-jul-03
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2003, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test.org.brains2b.data.sql;

import junit.framework.TestCase;

import org.brains2b.data.sql.SqlDataHelper;

/** Unit test for org.brains2b.sql.oracle.OracleDataHelper
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.1 [03-07-2003]
 * @see org.brains2b.sql.oracle.OracleDataHelper
 */
public class SqlDataHelperTest extends TestCase {

    /**
     * Constructor for OracleDataHelperTest.
     * @param arg0
     */
    public SqlDataHelperTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(SqlDataHelperTest.class);
    }

    public void testGetYesNo() {
    	assertEquals("N",SqlDataHelper.getYesNo(false));
    	assertEquals("Y",SqlDataHelper.getYesNo(true));
    }

    public void testGetBoolean() {
    	assertTrue(SqlDataHelper.getBoolean("Y"));
    	assertTrue(SqlDataHelper.getBoolean("   Y    "));
    	assertTrue(!SqlDataHelper.getBoolean("N"));
    	assertTrue(!SqlDataHelper.getBoolean("Humpty Dumpty"));
    }

	 public void testGetBooleanFail() {
	 	try {
	 		SqlDataHelper.getBoolean(null);
	 	} catch (NullPointerException npex) {
	 		assertTrue(true);
	 	} catch (Exception ex) {
	 		assertTrue("Other exception thrown " + ex.getClass().getName(),false);	
	 	}
	 }
}
