/* OracleConditionTest.java
 * 
 * Created on: Mar 06, 2003
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2003-2004, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 /* @#History
* [When]			[Who]							[What]
* Apr 17, 2004	dennis@brains2b.nl 		rewritten to use DEPT/EMP tables
*/
package test.org.brains2b.data.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

import junit.framework.TestCase;

import org.brains2b.data.sql.SqlCondition;
import org.brains2b.sql.LocalConnector;
import org.brains2b.util.DateHelper;

/** Unit test for OracleCondition
 * <p><i>Note: </i> Change de database connection in
 * setUp to connect to a valid database. 
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.3 [17-04-2004]
 * @see org.brains2b.sql.oracle.OracleCondition
 */
public class SqlConditionTest extends TestCase {
	private LocalConnector m_con;
	/**
	 * Constructor for OracleConditionTest.
	 * @param arg0
	 */
	public SqlConditionTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(SqlConditionTest.class);
	}

	/**
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		m_con=new LocalConnector(
		"oracle.jdbc.driver.OracleDriver",
		"jdbc:oracle:thin:@arthur:1521:merlin",
		"scott",
		"miauw");
	}

	public void testGetPreparedStatement() {
		try {
			SqlCondition cond=new SqlCondition();
			cond.setPreparedQuery("WHERE HIREDATE<?");
			cond.addParameter(1,new Timestamp(new Date().getTime()));
			cond.addCondition("ENAME","SCOTT");
			
			PreparedStatement stmt=cond.getPreparedStatement(m_con.getConnection(),"SELECT * FROM EMP");
			ResultSet rs=stmt.executeQuery();
			if (rs.next()) {
				assertEquals(7788,rs.getInt(1));
			} else {
				assertTrue("no record found",false);
			}
		} catch (SQLException sqex) {
			assertTrue(sqex.getMessage(),false);
		}
	}
	
	public void testGetPreparedStatementNull() {
		try {
			SqlCondition cond=new SqlCondition();
			cond.setPreparedQuery("WHERE HIREDATE<?");
			cond.addParameter(1,null);
						
			PreparedStatement stmt=cond.getPreparedStatement(m_con.getConnection(),"SELECT * FROM EMP");
			ResultSet rs=stmt.executeQuery();
			if (!rs.next()) {
				assertTrue("no record found",true);
			}
		} catch (SQLException sex) {
			assertTrue(sex.getMessage(),false);
		}
	}
	
	public void testGetPreparedStatement2() {
		try {
			SqlCondition cond=new SqlCondition();
			cond.setPreparedQuery("WHERE ENAME=? AND HIREDATE<?");
			cond.addParameter(1,"SCOTT");
			cond.addParameter(2,new Date());
						
			PreparedStatement stmt=cond.getPreparedStatement(m_con.getConnection(),"SELECT * FROM EMP");
			ResultSet rs=stmt.executeQuery();
			if (rs.next()) {
				assertEquals(7788,rs.getInt(1));
			} else {
				assertTrue("no record found",false);
			}
		} catch (SQLException sex) {
			assertTrue(sex.getMessage(),false);
		}
	}
	
	public void testGetPreparedStatement3() {
		try {
			SqlCondition cond=new SqlCondition();
			cond.addCondition("ENAME","SCOTT");
			
			PreparedStatement stmt=cond.getPreparedStatement(m_con.getConnection(),"SELECT * FROM EMP");
			ResultSet rs=stmt.executeQuery();
			if (rs.next()) {
				assertEquals(7788,rs.getInt(1));
			} else {
				assertTrue("no record found",false);
			}
		} catch (SQLException sex) {
			assertTrue(sex.getMessage(),false);
		}
	}
	
	public void testGetPreparedStatement4() {
		try {
			SqlCondition cond=new SqlCondition();
			cond.setPreparedQuery("WHERE HIREDATE<?");
			cond.addParameter(1,new Timestamp(new Date().getTime()));
			cond.addCondition("ENAME","SCOTT");
			cond.addOrderBy("ENAME");
			PreparedStatement stmt=cond.getPreparedStatement(m_con.getConnection(),"SELECT * FROM EMP");
			ResultSet rs=stmt.executeQuery();
			if (rs.next()) {
				assertEquals(7788,rs.getInt(1));
			} else {
				assertTrue("no record found",false);
			}
		} catch (SQLException sex) {
			assertTrue(sex.getMessage(),false);
		}
	}
	
	public void testgetCondition() {
		SqlCondition cond=new SqlCondition();
		cond.addCondition("HIREDATE",null);
		cond.addCondition("NAME","sc%");
		cond.addCondition("ID",5);
		
		assertEquals(" WHERE HIREDATE is NULL AND NAME like 'sc%' AND ID = 5 ",
			cond.getCondition());
		
	}
	
	public void testaddDateCondition() {
		try {
			SqlCondition cond=new SqlCondition();
			cond.addCondition("HIREDATE",DateHelper.toDate("19-APR-1987"));
			PreparedStatement stmt=cond.getPreparedStatement(m_con.getConnection(),"SELECT * FROM EMP");
			ResultSet rs=stmt.executeQuery();
			if (rs.next()) {
				assertEquals(7788,rs.getInt(1));
			} else {
				assertTrue("no record found",false);
			}
		} catch (SQLException sex) {
			assertTrue(sex.getMessage(),false);
		}
	
	}
	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
		m_con.close();
	}

}
