/* CursorDataTest.java
 * 
 * Created on: Apr 5, 2003
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2003,2004, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test.org.brains2b.data.cursor;

import java.math.BigDecimal;

import junit.framework.TestCase;

import org.brains2b.data.cursor.CursorData;

/** Unit test for org.brains2b.data.cursor.CursorData
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.2 [17-04-2004]
 * @see org.brains2b.data.cursor.CursorData
 */
public class CursorDataTest extends TestCase {

	private CursorData m_cdata;

    /**
     * Constructor for CursorDataTest.
     * @param arg0
     */
    public CursorDataTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(CursorDataTest.class);
    }

	/**
     * @see junit.framework.TestCase#setUp()
     */
    public void setUp() {
        m_cdata=new CursorData("TEST");
    }


    public void testCursorData() {
		assertEquals(0,m_cdata.getColumnCount());
		m_cdata.setColumn(0,"TEST_COLUMN");    	
    	assertEquals(1,m_cdata.getColumnCount());
    	assertEquals("TEST_COLUMN", m_cdata.getColumn(0));
    }

	public void testCursorDataClone() {
    	m_cdata.setColumnValue(0,"TEST_COLUMN","VALUE");
    	CursorData clone=(CursorData) m_cdata.clone();
    	assertTrue	(!m_cdata.equals(clone));
    	assertEquals(m_cdata.getName(),clone.getName());
    	assertEquals(m_cdata.getColumn(0),clone.getColumn(0));
    	assertTrue	(!m_cdata.getValue(0).equals(clone.getColumn(0)));
    	
    }

    public void testSetColumn() {
    	m_cdata.setColumn(2,"COLUMN2");
    	m_cdata.setColumn(0,"COLUMN0");	
	    m_cdata.setColumn(1,"COLUMN1");	
    	assertEquals("COLUMN0",m_cdata.getColumn(0));
    	assertEquals("COLUMN2",m_cdata.getColumn(2));
    }

    /*
     * Test for void setValue(String, Object)
     */
    public void testSetValueStringObject() {
    	m_cdata.setColumn(0,"STRING_COLUMN");
    	m_cdata.setColumn(1,"INT_COLUMN");
    	m_cdata.setColumn(2,"DATE_COLUMN");
    	
    	m_cdata.setValue("INT_COLUMN",new BigDecimal(10));
    	m_cdata.setValue("STRING_COLUMN","TEST_STRING");
    	
    	assertEquals(new BigDecimal(10),m_cdata.getValue(1));
    	assertEquals("TEST_STRING",m_cdata.getValue(0));
    }

    /*
     * Test for int getIntValue(String)
     */
    public void testGetIntValueString() {
    	m_cdata.setColumn(0,"STRING_COLUMN");
    	m_cdata.setColumn(1,"INT_COLUMN");
    	
    	m_cdata.setValue("INT_COLUMN",new BigDecimal(10));
    	m_cdata.setValue("STRING_COLUMN","TEST_STRING");
    	
    	assertEquals(10,m_cdata.getIntValue(1));
    	try {
    		assertEquals(0,m_cdata.getIntValue(0));
    	} catch (NumberFormatException nfex) {
    		assertTrue(true);
    	}
    	
    }

	public void testsetColumnType() {
		m_cdata.setColumn(0,"STRING_COLUMN");
		m_cdata.setColumnType(0,String.class);
		m_cdata.setColumnType(1,Integer.TYPE);
		
		m_cdata.setValue(1,new BigDecimal(10));
    	m_cdata.setValue("STRING_COLUMN","TEST_STRING");
    	
    	assertEquals(m_cdata.getColumnType(1),Integer.TYPE);
    	assertEquals(m_cdata.getColumnType("STRING_COLUMN"),String.class);
	}

	public void testsetColumnValue() {
		m_cdata.setColumnValue(0,"STRING_COLUMN","TEST_STRING");
		m_cdata.setColumnValue(1,"INT_COLUMN",new BigDecimal(10));
		
		assertEquals("TEST_STRING",m_cdata.getValue(0));
		assertEquals("TEST_STRING",m_cdata.getValue("STRING_COLUMN"));
		assertEquals(10,m_cdata.getIntValue(1));
		assertEquals(10,m_cdata.getIntValue("INT_COLUMN"));
		
	}
}
