/* 	HashCodeHelperTest.java
 *	Copyright (c) 2006, Brains2B.org
 *	
 *	Created by: Dennis Groenendijk
 *	Created on: Jun 08, 2006
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that  * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test.org.brains2b.data;

import org.brains2b.data.HashCodeHelper;

import junit.framework.TestCase;

public class HashCodeHelperTest extends TestCase {

	
	public HashCodeHelperTest(String arg0) {
		super(arg0);
	}

	/*
	 * Test method for 'org.brains2b.data.HashCodeHelper.hash(int, int)'
	 */
	public void testHashIntInt() {
		assertEquals( 0,HashCodeHelper.hash(0,0));
		assertEquals(37,HashCodeHelper.hash(1,0));
		assertEquals( 1,HashCodeHelper.hash(0,1));
		assertEquals(Integer.MAX_VALUE,HashCodeHelper.hash(0,Integer.MAX_VALUE) );
	}

	/*
	 * Test method for 'org.brains2b.data.HashCodeHelper.hash(int, boolean)'
	 */
	public void testHashIntBoolean() {
		assertEquals(1,HashCodeHelper.hash(0,true));
		assertEquals(0,HashCodeHelper.hash(0,false));
	}

	/*
	 * Test method for 'org.brains2b.data.HashCodeHelper.hash(int, long)'
	 */
	public void testHashIntLong() {
		assertEquals( 0,HashCodeHelper.hash(0,0l));
		assertEquals(37,HashCodeHelper.hash(1,0l));
		assertEquals( 1,HashCodeHelper.hash(0,1l));
		assertEquals(Integer.MIN_VALUE,HashCodeHelper.hash(0,Long.MAX_VALUE));
	}

	/*
	 * Test method for 'org.brains2b.data.HashCodeHelper.hash(int, double)'
	 */
	public void testHashIntDouble() {
		assertEquals( 0,HashCodeHelper.hash(0,0.0d));
		assertEquals(37,HashCodeHelper.hash(1,0.0d));
		assertEquals(1072693248,HashCodeHelper.hash(0,1.0d));
		assertEquals(-2146435072,HashCodeHelper.hash(0,Double.MAX_VALUE));
	}

	/*
	 * Test method for 'org.brains2b.data.HashCodeHelper.hash(int, float)'
	 */
	public void testHashIntFloat() {
		
		assertEquals( 0,HashCodeHelper.hash(0,0.0f));
		assertEquals(37,HashCodeHelper.hash(1,0.0f));
		assertEquals(1065353216,HashCodeHelper.hash(0,1.0f));
		assertEquals(2139095039,HashCodeHelper.hash(0,Float.MAX_VALUE));

	}

	/*
	 * Test method for 'org.brains2b.data.HashCodeHelper.hash(int, Object)'
	 */
	public void testHashIntObject() {
		assertEquals( 0,HashCodeHelper.hash(0,null));
		assertEquals( 0,HashCodeHelper.hash(0,""));
		assertEquals(-1808118735,HashCodeHelper.hash(0,"String"));
	}
	
	public void testMaxAddition() {
		int result=HashCodeHelper.INITIAL;
		result = HashCodeHelper.hash(result,Float.MAX_VALUE);
		result = HashCodeHelper.hash(result,Double.MAX_VALUE);
		result = HashCodeHelper.hash(result,Long.MAX_VALUE);
		result = HashCodeHelper.hash(result,Integer.MAX_VALUE);
		assertEquals(1753415263,result);
		
		
		int result2=HashCodeHelper.INITIAL;
		result2 = HashCodeHelper.hash(result2,Integer.MAX_VALUE);
		result2 = HashCodeHelper.hash(result2,Long.MAX_VALUE);
		result2 = HashCodeHelper.hash(result2,Double.MAX_VALUE);
		result2 = HashCodeHelper.hash(result2,Float.MAX_VALUE);
		assertTrue(result2!=result);
		
	}

}
