/*
 * Created on Feb 16, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package test.org.brains2b.data;

import java.math.BigDecimal;
import java.util.Date;

import org.brains2b.data.CopyException;
import org.brains2b.data.DataHelper;
import org.brains2b.data.cursor.CursorData;

import junit.framework.TestCase;

/**
 * @author dennis
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DataHelperTest extends TestCase {

	public class A {
		private String name;

		private Date date;

		private int number;

		private Object myObject;

		/**
		 * @return
		 */
		public Date getDate() {
			return date;
		}

		/**
		 * @return
		 */
		public Object getMyObject() {
			return myObject;
		}

		/**
		 * @return
		 */
		public String getName() {
			return name;
		}

		/**
		 * @return
		 */
		public int getNumber() {
			return number;
		}

		/**
		 * @param date
		 */
		public void setDate(Date date) {
			this.date = date;
		}

		/**
		 * @param object
		 */
		public void setMyObject(Object object) {
			myObject = object;
		}

		/**
		 * @param string
		 */
		public void setName(String string) {
			name = string;
		}

		/**
		 * @param i
		 */
		public void setNumber(int i) {
			number = i;
		}

	}

	public class C {
		private String name;

		private String date;

		private int number;

		private Object myObject;

		/**
		 * @return
		 */
		public String getDate() {
			return date;
		}

		/**
		 * @return
		 */
		public Object getMyObject() {
			return myObject;
		}

		/**
		 * @return
		 */
		public String getName() {
			return name;
		}

		/**
		 * @return
		 */
		public int getNumber() {
			return number;
		}

		/**
		 * @param date
		 */
		public void setDate(String date) {
			this.date = date;
		}

		/**
		 * @param object
		 */
		public void setMyObject(Object object) {
			myObject = object;
		}

		/**
		 * @param string
		 */
		public void setName(String string) {
			name = string;
		}

		/**
		 * @param i
		 */
		public void setNumber(int i) {
			number = i;
		}

	}

	public class B {
		private String name;

		private Date date;

		private int number;

		private Object thoughObject;

		/**
		 * @return
		 */
		public Date getDate() {
			return date;
		}

		/**
		 * @return
		 */
		public String getName() {
			return name;
		}

		/**
		 * @return
		 */
		public int getNumber() {
			return number;
		}

		/**
		 * @param date
		 */
		public void setDate(Date date) {
			this.date = date;
		}

		/**
		 * @param string
		 */
		public void setName(String string) {
			name = string;
		}

		/**
		 * @param i
		 */
		public void setNumber(int i) {
			number = i;
		}

		/**
		 * @return
		 */
		public Object getThoughObject() {
			return thoughObject;
		}

		/**
		 * @param object
		 */
		public void setThoughObject(Object object) {
			thoughObject = object;
		}

	}

	/**
	 * Constructor for DataHelperTest.
	 * @param arg0
	 */
	public DataHelperTest(String arg0) {
		super(arg0);
	}

	public void testCopyDataObject_toItself() {
		A a = new A();
		a.setDate(new Date());
		a.setMyObject(new Exception());
		a.setName("TEST_A");
		a.setNumber(10);
		A result = new A();
		try {
			DataHelper.copyDataObject(a, result);
			assertEquals(a.getDate(), result.getDate());
			assertEquals(a.getMyObject(), result.getMyObject());
			assertEquals(a.getName(), result.getName());
			assertEquals(a.getNumber(), result.getNumber());
		} catch (CopyException cpex) {
			assertTrue(cpex.getMessage(), false);
		}

	}

	public void testCopyDataObject_toOther() {
		A a = new A();
		a.setDate(new Date());
		a.setMyObject(new Exception());
		a.setName("TEST_A");
		a.setNumber(10);
		B result = new B();
		try {
			DataHelper.copyDataObject(a, result);
			assertEquals(a.getDate(), result.getDate());
			assertEquals(a.getName(), result.getName());
			assertEquals(a.getNumber(), result.getNumber());
		} catch (CopyException cpex) {
			assertTrue(cpex.getMessage(), false);
		}

	}

	public void testCopyDataObject_Fail() {
		A a = new A();
		a.setDate(new Date());
		a.setMyObject(new Exception());
		a.setName("TEST_A");
		a.setNumber(10);
		C result = new C();
		try {
			DataHelper.copyDataObject(a, result);
			assertEquals(a.getDate(), result.getDate());
			assertEquals(a.getName(), result.getName());
			assertEquals(a.getNumber(), result.getNumber());
		} catch (CopyException cpex) {
			assertTrue(cpex.getMessage(), true);
		}

	}
	
	public void testCopyCursorData() {
		A a = new A();
		CursorData cd=new CursorData("TEST");
		cd.setColumnValue(0,"NAME","MyTest");
		cd.setColumnType(0,String.class);
		cd.setColumnValue(1,"NUMBER", new BigDecimal(10));
		cd.setColumnType(1,Integer.TYPE);
		cd.setColumnValue(2,"DATE", new Date());
		cd.setColumnType(2,Date.class);
		cd.setColumnValue(3,"MY_OBJECT", new BigDecimal(192010));
		cd.setColumnType(3,Object.class);
		cd.setColumnValue(4,"NOT_FOUND", "MyMy");
		cd.setColumnType(4,Object.class);
		try {
			DataHelper.copyDataObject(cd,a);
			assertEquals(a.getName(),cd.getValue("NAME"));
			assertEquals(a.getNumber(),cd.getIntValue("NUMBER"));
			assertEquals(a.getDate(),cd.getValue("DATE"));
			assertEquals(a.getMyObject(),cd.getValue("MY_OBJECT"));
		} catch (CopyException cpex) {
			assertTrue(cpex.getMessage(), true);
		}
	}
}
