package test.org.brains2b.data;

import java.util.Map;

import junit.framework.TestCase;

import org.brains2b.data.Condition;

/** JUnit test for Condition
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.10 [19-06-2003]
 * @see org.brains2b.data.Condition
 */
public class ConditionTest extends TestCase {

	public class ACondition extends Condition {
        /**
         * @see org.brains2b.data.Condition#getCondition()
         */
        public Object getCondition() {
            return this;
        }

	}

    /**
     * Constructor for ConditionTest.
     * @param arg0
     */
    public ConditionTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ConditionTest.class);
    }
    /*
     * Test for void Condition()
     */
    public void testCondition() {
    	    	
    }

    /*
     * Test for void addCondition(String, Object)
     */
    public void testAddCondition() {
		Condition c=new ACondition();
		c.addCondition("iTest",0);
		c.addCondition("sTest","StringTest");
		Map m=c.getConditions();
		assertEquals(2,m.size());
		assertEquals(new Integer(0),m.get("iTest"));
		assertEquals("StringTest",m.get("sTest"));
    }
    
    public void testAddConditionFail() {
		Condition c=new ACondition();
		assertNull(c.getConditions());
		try {
			c.addCondition("nTest",null);
		} catch (NullPointerException npex) {
			assertTrue(true);
		}
		assertNull(c.getConditions());
    }

    public void testRemoveCondition() {
		Condition c=new ACondition();
		c.addCondition("iTest",0);
		assertEquals(1,c.getConditions().size());
		c.removeCondition("iTest");
		assertNull(c.getConditions());
		    	
    }

    public void testAddOrderBy() {
		Condition c=new ACondition();
		c.addOrderBy("iTest");
		assertNotNull(c.getOrderBy());
		assertEquals(1,c.getOrderBy().size());
		c.addOrderBy("sTest");
		assertEquals(2,c.getOrderBy().size());
    	assertEquals(1,c.getOrderBy().indexOf("sTest"));
    }

    public void testClearOrderBy() {
		Condition c=new ACondition();
		c.addOrderBy("iTest");
		c.addOrderBy("sTest");
		c.clearOrderBy();
		assertNull(c.getOrderBy());
    }


}
