/* 	OracleCursor.java
 *	Copyright (c) 2003-2007, Brains2B.org
 *	
 *	Created by: Dennis Groenendijk
 *	Created on: 04-08-2003
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that  * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
 /* @#History
 * [When]		[Who]					[What]
 * Mar 4, 2004	dennis@brains2b.nl		addParameter(int, Object) supports java.util.Date
 * Mar 31,2004	dennis@brains2b.nl		select statement wasn't properly closed
 * Apr 26,2005	dennis@brains2b.nl		added insert statement()		
 * 20-08-2006	dennis@brains2b.nl		possible open cursor fixed
 * 16-10-2006	dennis@brains2b.nl		Use SelectDescriptor for splitting up select statements
 * 20-10-2006	dennis@brains2b.nl		Use select(boolean) from OracleCursor for prototypes containing parameter
 * 01-11-2006   dennis@brains2b.nl      create prototype in OracleCursor
 * 18-06-2007   dennis@brains2b.nl      Only write the inserts for with a value not null to an insert statement
 */
package org.brains2b.sql.oracle.cursor;

import java.sql.Connection;
import java.util.Vector;

import org.brains2b.data.sql.cursor.SqlCursor;

/** Overwrite of the Cursor object to add functionality for having queries with parameters.
 * <p>The sql statement can contain placeholder characters <code>?</code> signifying a
 * parameter which can be set at runtime by calling addParameter(index, value). The index 
 * corresponds with the count of the placeholder character in the SQL statement starting at <b>1</b>
 * 
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.22.3 [18-06-2007]
 * @deprecated use SqlCursor
 */
public class OracleCursor extends SqlCursor {

	
    /**
     * Constructor for OracleCursor.
     * @deprecated use OracleCursor(String, String) and OracleCursor(Connection,String,String)
     */
    public OracleCursor() {
        super(null,null);
    }

	/**
	 * Constructor for OracleCursor
	 * @param name String, the name of the cursor
	 * @param sql String, the SQL-statement to use for this cursor
	 */
	public OracleCursor(String name, String sql) {
		super(null,name,sql);
		
	}

	/**
     * Constructor for OracleCursor.
     * <p>Usually the Connection does not have to be set at initialization, you can
     * use setConnection(Connection)
     * @param con java.sql.Connection, the JDBC connection to use for this Cursor
     * @param name String, the name of the cursor
	 * @param sql String, the SQL-statement to use for this cursor
     */
    public OracleCursor(Connection con, String name, String sql) {
        super(con, name, sql);
    }
    
    public Vector select() throws Exception {
    	return new Vector(retrieveList());
    }
}
