/* 	OracleDC.java
 * 
 * Created on: 20-01-2002
 * Created by: Dennis Groenendijk
 * 
 * Copyright (c) 2002,2003, Brains2B.org
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that
 * the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and 
 * the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and
 * the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * 3. The name of the author may not be used to endorse or promote products derived from this software 
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.brains2b.sql.oracle;

import java.sql.Connection;

import org.brains2b.data.sql.SqlDC;

/** Abstract class for OraceDataControl objects.
 *  <p>Implements the Object to hold, the Connection and the PreparedStatement to use
 *  but propagates all methods of the DataControl interface for concrete implementation
 *  <p>Adds an additional protected abstract method <code>getObject(ResultSet)</code> as a standardized
 *  method to create a data Object from a given ResultSet  
 *
 * @author <A HREF="MAILTO:dennis@brains2b.nl">dennis@brains2b.nl</A>
 * @version 0.1 [20-01-2002]
 * @see org.brains2b.data.DataControl
 * @deprecated use SqlDC instead
 */
public abstract class OracleDC extends SqlDC {
	
    /**
     * Constructor for OracleDC which sets the Connection
     * to use for this DataControl and the Object on which it should
     * operate.
     * @param con Connection, the JDBC connection to use
     * @param o Object, the Object for which this DataControl exists.
     */
	public OracleDC(Connection con, Object o) {
		super(con, o);
	}
	
}
